<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bank extends CI_Controller {

    var $main_menu_name = "settings";
	var $sub_menu_name = "bank";

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Bank_Model');
		$this->load->model('Sequerty_Model');
	}
	
	public function index()
	{
		$data['banks'] = $this->Bank_Model->get_all_bank();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('bank',$data);
	}
	
	public function save_bank()
	{
		$bank_id=$this->input->post('bank_id');
		$type=$this->input->post('type');
		$name=$this->input->post('name');
		$code=$this->input->post('code');
		$phone=$this->input->post('phone');
		$email=$this->input->post('email');
		$address=$this->input->post('address');

		$data=array(
			'name'=>$name,
			'code'=>$code,
			'phone'=>$phone,
			'email'=>$email,
			'address'=>$address
		);
		
		$_insert=$this->Bank_Model->save_bank($data,$bank_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
	}


public function get_list_bank($value='')
	{
	        $values = $this->Bank_Model->get_all_bank();
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $users) {
					
	            $row = array();
	                $row[] = $users->code;
	                $row[] = $users->name;
	                $row[] = $users->phone;
	                $row[] = $users->email;
					$row[] = $users->address;
										
					$actionTxtDisble='';
					$actionTxtEnable='';
					$actionTxtUpdate='';
					$actionTxtDelete='';
					$actionTxtUpdate='<a onClick="click_bank_update_btn('.$users->id.')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
					if($users->status==1){
						$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable customer" onClick="disableBankData('.$users->id.')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
				}
					if($users->status==0){
						$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable customer" onClick="enableBankData('.$users->id.')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
				}
					$actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete customer" onClick="deleteBankData('.$users->id.')">
																		<i class="glyphicon fa fa-trash-o"></i></a>';
				
				$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable;
	
	                $data[] = $row;
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
	   
	

	public function create_bank()
	{
        if (isset($_GET['bank_id'])) {
			$bank_id=$_GET['bank_id'];
		}
		else {
			$bank_id='';
		}
		if($bank_id){
			$data['bank_id']=$bank_id;
			$data['type']='E';
			$data['pageName']='UPDATE WAREHOUSE';
			$data['btnText']='Update Bank';
			$data['bank_list']= $this->Bank_Model->get_bank_info($bank_id);	
		}
		else {
			$data['bank_id']='';
			$data['type']='A';
			$data['pageName']='ADD WAREHOUSE';
			$data['btnText']='Add Bank';
			$data['suppliyer']=array();
		}
        $this->load->view('models/create_bank',$data);
	}


	function delete_bank() {
		$bank_id	= $this->input->post('bank_id');
		$this->Bank_Model->delete_bank($bank_id);
        if ($bank_id) {
        	echo json_encode(array('id'=>$bank_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_bank() {
		$bank_id	= $this->input->post('bank_id');
		$this->Bank_Model->disable_bank($bank_id);
        if ($bank_id) {
        	echo json_encode(array('id'=>$bank_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_bank() {
		$bank_id	= $this->input->post('bank_id');
		$this->Bank_Model->enable_bank($bank_id);
        if ($bank_id) {
        	echo json_encode(array('id'=>$bank_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}