<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Holiday_Management extends CI_Controller {

    var $main_menu_name = "holiday_management";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();
		
		
		
		$this->load->model('Common_Model');
		$this->load->model('Holiday_Model');
		$this->load->model('User_Model');
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "list_holiday";
        $this->load->view('holiday_list',$data);
	}
	
	
	
	public function list_holiday()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "list_holiday";
        $this->load->view('holiday_list',$data);
	}
	
	public function create_holiday()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "";
        $this->load->view('models/create_holiday',$data);
	}
	
	
	public function save_holiday()
	{
		$id='';
		
		$this->load->library('form_validation'); //form validation lib
        $this->form_validation->set_rules('type', 'TYPE', 'required');
        $this->form_validation->set_rules('holiday_date', 'Holiday', 'required|trim|xss_clean|is_unique[holiday.holiday_date]');
		$this->form_validation->set_rules('remarks', 'Remarks', 'trim|xss_clean');
		$type=$this->input->post('type');
		$remarks=$this->input->post('remarks');		
		$holiday_date=$this->input->post('holiday_date');
		$user_id = $this->session->userdata('ss_user_id');
        $added_date_time = date("Y-m-d H:i:s");
		//$date = DateTime::createFromFormat("Y-m-d",$holiday_date);
		$year= date('Y', strtotime($holiday_date));
		$month= date('F', strtotime($holiday_date));
		$date= date('Y-m-d', strtotime($holiday_date));
		
		if ($this->form_validation->run() == FALSE) {
            echo json_encode(array(
                'id' => '',
                'type' => $type,
                'status' => validation_errors()
            ));
        } else {
		$data=array(
			'added_user'=>$user_id ,
			'added_date_time'=>$added_date_time,
			'year'=>$year,
			'month'=>$month,
			'holiday_date'=>$date,	
			'remarks'=>$remarks		
		);		
       	$_insert=$this->Holiday_Model->save_holiday($data,$id);
		$lastid=$this->db->insert_id();
		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
		
		
	}
	
	
	
	public function list_holidays()
	{
		 $values = $this->Holiday_Model->get_all_holiday();
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $users) {
					
	            $row = array();
	                $row[] = $users['holiday_date'];
	                $row[] = $users['year'];
	                $row[] = $users['month'];
	                $row[] = $users['remarks'];										
					$actionTxtDisble='';
					$actionTxtEnable='';
					$actionTxtUpdate='';
					$actionTxtDelete='';
					$actionTxtUpdate='<a onClick="click_bank_update_btn('.$users['holiday_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
					if($users['status']==1){
						$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable customer" onClick="disable_holiday('.$users['holiday_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
				}
					if($users['status']==0){
						$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable customer" onClick="enable_holiday('.$users['holiday_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
				}
					
				
				$row[]=$actionTxtDisble.$actionTxtEnable;
	
	                $data[] = $row;
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
		
		
	}
	
	 // -------------------------------------------------------------------------------------
	  
}