<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Loan_Issue extends CI_Controller {

    var $main_menu_name = "loan_issue";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Management_Model');
		$this->load->model('Loan_Model');
		$this->load->model('Loan_Issue_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Bank_Model');
		$this->load->model('Common_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Menu_Model');
		$this->load->model('User_Model');
		$this->load->model('System_Settings_Model');
		$this->load->model('Unit_Model');
		$this->load->model('Menu_Items_List_Model');
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // -------------------------------------------------------------------------------------
	  
	  public function pending_issue()
	{		 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "issue_penidng_loan";
        $this->load->view('issue_penidng_loan',$data);
	}	  
	  
	  public function get_list_loan_pending_issue($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==2){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Loan_Issue_Model->getLoan_approved_pending_issue(0);
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;
					if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}					
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}
					$row[] = $users->loan_id;
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
	                $row[] = $pTname;					
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_interest.' %';					
					$loan_editable=false;
					$loan_editable=false;
						
					$total_issued_amount=$this->Loan_Model->get_total_issued_by_loan_id($loan_id);						 					
					$pay_st="undifine";
					
					if  ($users->loan_issue_status==0)
					{
						$pay_st = '<span class="label label-yellow">Pending</span>';
					}
					
					if  ($users->loan_issue_status==1)
					{
						$pay_st = '<span class="label label-success">Issued</span>';
					}
					
					if  ($users->loan_issue_status==2)
					{
						$pay_st = '<span class="label label-info">Partial Issue</span>';
					}
					 	$row[] = $pay_st;	
						$app_status='';						
						if($users->approval_status==1)
						{
							$app_status='<span class="label label-success">Approved</span>';
						}
						if($users->approval_status==0)
						{
							$app_status='<span class="label label-info">Pending</span>';
						}
						if($users->approval_status==(-1))
						{
							$app_status='<span class="label danger">Reject</span>';
						}						
					$row[] = $app_status;	
					$row[] = number_format($users->loan_tot_amount, 2, '.', ',');	
					$row[]=number_format($total_issued_amount['issue_amount'], 2, '.', ',');	
					$row[] =number_format($users->loan_tot_amount-$total_issued_amount['issue_amount'], 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="'.base_url().'loan/details/'.$users->loan_id.'"><i class="fa fa-trash-o"></i> Loan Details</a></li>
						  <li><a href="'.base_url().'loan_issue/issue_appeoval_loan/'.$users->loan_id.'"><i class="fa fa-file-text-o"></i> Issue The Loan  </a></li>
															
                       </ul></div>';										
				$row[]=$row_action;				
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	   
	public function issue_appeoval_loan()
	{		 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "issue_appeoval_loan";
		$loan_id=$this->uri->segment('3');
		$data['details'] = $this->Loan_Model->get_loan_details_by_loan_id($loan_id);
		$issue_amount= $this->Loan_Issue_Model->get_loan_issue_total_by_loan_id($loan_id);	
		
		if($issue_amount['issue_amount']>0)
		{
			$data['issue_amount']=$issue_amount['issue_amount'];
		}
		else
		{
			$data['issue_amount']=0;
		}		
		$data['bank_list'] = $this->Bank_Model->get_all_bank();
        $this->load->view('loan_issue_update',$data);
	}	  
	  
	public function get_list_loan_issue_amount_details_by_loan_id()
	{	
			$loan_id=$this->input->get('id');
	        $values = $this->Loan_Issue_Model->getLoan_issued_and_partial_issued($loan_id);
			
			//print_r( $values);
			
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->id;
					$issue_type="";					
					if($users->issue_type==1)
					{
					$issue_type="Cash";
					$cheque_number = "";	
	                $cheque_date = "";										  
					$cheque_payee = "";
					$cheque_bank = "";
					$cheque_branch ="";	
					}
					if($users->issue_type==2)
					{
					$issue_type="Cheque";
					$cheque_number = $users->cheque_number;	
	                $cheque_date = $users->cheque_date;										  
					$cheque_payee = $users->cheque_payee;
					$cheque_bank = $users->bank_code;
					$cheque_branch = $users->cheque_branch;											 
					}
					
					
					$row[] = "";		
					$row[] = $users->id;
					$row[] = $users->issue_date_time;
					$row[] = $issue_type;                
	                $row[] = $users->issue_amount;
					$row[] = $cheque_number;	
	                $row[] = $cheque_date;										  
					$row[] = $cheque_payee;
					$row[] = $cheque_bank;
					$row[] = $cheque_branch;											 
																							
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">                       
							
							<li><a href="#" onClick="rejecst('.$users->id.')"><i class="fa fa-file-text-o"></i> Return</a></li>
									
                       </ul></div>';
										
					$row[]=$row_action;				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;	
	                $data[] = $row;
	            }
				
	           $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   } 
	   
	   
	   //-----------------------------------------------------------------
	   
	   
	   
	   function update_issue_loan_details()
	   {
		   $loan_id=$this->input->post('loan_id');
		   $cus_id=$this->input->post('cus_id');
		   $route_id=$this->input->post('route_id');
		   $warehouse_id=$this->input->post('warehouse_id');
		   $payment_type=$this->input->post('payment_type');
		   $loan_issue_date=$this->input->post('loan_issue_date');
		   $cheqe_number=$this->input->post('cheqe_number');
		   $chque_date=$this->input->post('chque_date');
		   $contact_no=$this->input->post('contact_no');
			$issue_bank=$this->input->post('bank_id');
			$issue_brnach=$this->input->post('issue_brnach');
			$amount=$this->input->post('amount');
			$payee=$this->input->post('payee');
			
			$details_confirm = $this->Loan_Model->get_loan_details_by_loan_id($loan_id);			
			$issue_amount= $this->Loan_Issue_Model->get_loan_issue_total_by_loan_id($loan_id);	
			
			if($issue_amount['issue_amount']>0)
			{
			$issued_amount=$issue_amount['issue_amount'];
			}
			else
			{
			$issued_amount=0;
			}			
			
			$check= $details_confirm['loan_tot_amount']-$issued_amount;		
			
			
			if($cus_id==$details_confirm['cus_id']&& $amount<=$check&& $amount>0){
			if($payment_type==2)
			{
			$data=array(
			'loan_id'=>$loan_id, 
			'cus_id'=>$cus_id,
			'warehouse_id'=>$warehouse_id,
			'issue_type'=>$payment_type,
			'issue_date_time'=>date('Y-m-d', strtotime($loan_issue_date)) ,			
			'issue_amount'=>$amount,
			'cheque_number'=>$cheqe_number,
			'cheque_date'=>date('Y-m-d', strtotime($chque_date)) ,
			'cheque_payee'=>$payee,
			'cheque_bank'=>$issue_bank,
			'cheque_branch'=>$issue_brnach,
			'system_date_time'=>date("Y-m-d H:i:s"),
			'added_user'=>$this->session->userdata('ss_user_id'),		
			);
			}
			else
			{
			$data=array(
			'loan_id'=>$loan_id, 
			'cus_id'=>$cus_id,
			'warehouse_id'=>$warehouse_id,
			'issue_type'=>$payment_type,
			'issue_date_time'=>date('Y-m-d', strtotime($loan_issue_date)) ,			
			'issue_amount'=>$amount,			
			'system_date_time'=>date("Y-m-d H:i:s"),
			'added_user'=>$this->session->userdata('ss_user_id'),		
			);			
				
			}			
			$result1=$this->Loan_Issue_Model->save_loan_issue($data);
			
			$issue_amount= $this->Loan_Issue_Model->get_loan_issue_total_by_loan_id($loan_id);	
			
			if($issue_amount['issue_amount']>0)
			{
			$issued_amount=$issue_amount['issue_amount'];
			}
			else
			{
			$issued_amount=0;
			}	
			
			if($details_confirm['loan_tot_amount']==$issued_amount)
			{
				$issue_status=1;
			}
			else
			{
				$issue_status=2;
			}	
			
			$data=array('loan_issue_status'=>$issue_status);
			
			$result2= $this->Loan_Issue_Model->update_loan_issue_status($loan_id,$data);		
			
			if($result1==1&&$result2==1){
			echo json_encode(array('loan_id'=>$loan_id,'error'=>0,'msg'=>'Successfuly_saved'));	
		}else{
			echo json_encode(array('loan_id'=>$loan_id,'error'=>1,'msg'=>"Operation Faild"));
		}
		
			}
			
			else
			{
				echo json_encode(array('loan_id'=>$loan_id,'error'=>2,'msg'=>'Details Miss match. Please check Amount'));	
			}
			
			
	   }
	   
	   
	   
	   //-----------------------------------------------------------------
	   
	   
	  
	  // -------------------------------------------------------------------------------------
	  
	  public function issued_loan()
	{		 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "issued_loan";
        $this->load->view('issued_loan',$data);
	}	  
	  
	  public function get_list_loan_issued($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==2){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Loan_Issue_Model->getLoan_approved_issued(0);
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;
					$row[] = $users->loan_id;
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
	                $row[] = $users->payment_term_name;					
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_interest.' %';					
					$loan_editable=false;
					$loan_editable=false;
						
					$total_issued_amount=$this->Loan_Model->get_total_issued_by_loan_id($loan_id);						 
					$pay_st="undifine";					
					if  ($users->loan_issue_status==0)
					{
						$pay_st = '<span class="label label-yellow">Pending</span>';
					}					
					if  ($users->loan_issue_status==1)
					{
						$pay_st = '<span class="label label-success">Issued</span>';
					}					
					if  ($users->loan_issue_status==2)
					{
						$pay_st = '<span class="label label-info">Partial Issue</span>';
					}
					 	$row[] = $pay_st;	
						$app_status='';						
						if($users->approval_status==1)
						{
							$app_status='<span class="label label-success">Approved</span>';
						}
						if($users->approval_status==0)
						{
							$app_status='<span class="label label-info">Pending</span>';
						}
						if($users->approval_status==(-1))
						{
							$app_status='<span class="label danger">Reject</span>';
						}						
					$row[] = $app_status;	
					$row[] = number_format($users->loan_tot_amount, 2, '.', ',');	
					$row[]=number_format($total_issued_amount['issue_amount'], 2, '.', ',');	
					$row[] =number_format($users->loan_tot_amount-$total_issued_amount['issue_amount'], 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="'.base_url().'loan/details/'.$users->loan_id.'"><i class="fa fa-trash-o"></i> Loan Details</a></li>
						  <li><a href="'.base_url().'loan_issue/issue_appeoval_loan/'.$users->loan_id.'"><i class="fa fa-file-text-o"></i> Issue The Loan  </a></li>
															
                       </ul></div>';										
				$row[]=$row_action;				
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	 
	
	
	
	
	

}