<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Customer_Model extends CI_Model {
  
  private $tableName = 'customer';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
 
 	function save_customer(&$customer_data,$cus_id=false)
	{
		if (!$cus_id)
		{
			$this->db->insert($this->tableName,$customer_data);
		}else {
			$this->db->where('cus_id', $cus_id);
			return $this->db->update($this->tableName,$customer_data);
		}
	}
	
	function customer_location_save($cus_id,$data)
	{
		if ($cus_id>0)
		{
			$this->db->where('cus_id', $cus_id);
			return $this->db->update($this->tableName,$data);
		}
	}
	
	function get_all_customers() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("cus_id", "asc");
		$this->db->where("cus_status",1);//("id !=",$id);
		//$this->db->where("cus_id", $id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	
	function get_all_customer_del() {
		$this->db->select('customer.*');
		$this->db->from('mstr_country');
		$this->db->join('customer', 'customer.country_id = mstr_country.country_id', 'left');
		$this->db->order_by("customer.cus_id", "desc");
		$this->db->where("customer.cus_status IS NOT NULL");//("id !=",$id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_all_customer($start,$length,$search_key_val) {
		
		$search_key_val=preg_replace('/[^a-zA-Z0-9-_\.]/','', $search_key_val);
		
		$this->db->select($this->tableName.'.*');
		$this->db->select('routes.route_name');
		$this->db->from($this->tableName);
		$this->db->join('routes','routes.route_id=customer.cus_route','left');
		
		if($search_key_val){
            $this->db->where("customer.cus_code LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'OR customer.cus_nic LIKE '%$search_key_val%'OR customer.cus_mobile LIKE '%$search_key_val%'");
       }
       $this->db->order_by("cus_name", "asc");
       if($start!='' && $length!='')
	   {
        $this->db->limit($length,$start);
       	$query = $this->db->get(); 
      	return $query->result_array();     		
	   }
		else
		{
			$query = $this->db->get(); 
			return  $query->num_rows();			
		}

	}
	 function get_all_customer_filter($search_key_val) {
		
		//$search_key_val=preg_replace('/[^a-zA-Z0-9-_\.]/','', $search_key_val);
		
		$this->db->select($this->tableName.'.*');
		$this->db->select('routes.route_name');
		$this->db->from($this->tableName);
		$this->db->join('routes','routes.route_id=customer.cus_route','left');		
		if($search_key_val){
            $this->db->where("customer.cus_code LIKE '%$search_key_val%' OR customer.cus_name LIKE '%$search_key_val%'OR customer.cus_nic LIKE '%$search_key_val%'OR customer.cus_mobile LIKE '%$search_key_val%'");
       }
       $this->db->order_by("cus_name", "asc");       
        $this->db->limit(20);
       	$query = $this->db->get(); 
      	return $query->result_array();     		
	   }
	
	public function get_customer_info($id)
	 {
		$this->db->select('*');
		$this->db->from('customer');
		$this->db->where("cus_id", $id);
		$this->db->order_by("cus_id", "desc");
		$query = $this->db->get();
		return $query->row_array(); 
	 }
	
	public function delete_customer($cus_id)
	{
		$this->db->where('cus_id', $cus_id);
		$this->db->delete('customer');
	
	}

	public function disable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 0
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}
	
	public function enable_customer($cus_id)
	{
		$data = array(
			'cus_status' => 1
		);	
		$this->db->where('cus_id', $cus_id);
		$this->db->update('customer', $data);
	}	

}