<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Duration_Model extends CI_Model {
  
  private $tableName = 'mstr_duration';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	function save_duration(&$duration_data,$duration_id=false)
	{
		if (!$duration_id)
		{
			$this->db->insert($this->tableName,$duration_data);
		}else {
			$this->db->where('id', $duration_id);
			return $this->db->update($this->tableName,$duration_data);
		}
	}	
	
	function get_all_duration() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("id", "asc");
		$this->db->where("id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	public function get_duration_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("id", $id);
		$this->db->order_by("id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_duration($duration_id)
	{
		$this->db->where('id', $duration_id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_duration($duration_id)
	{
		$data = array(
			'status' => 0
		);	
		$this->db->where('id', $duration_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_duration($duration_id)
	{
		$data = array(
			'status' => 1
		);	
		$this->db->where('id', $duration_id);
		$this->db->update($this->tableName, $data);
	}
}