<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Google_Map_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	
	function get_all_loan_customer_location_updated($route_id) {
		$this->db->select('c.cus_id,c.cus_name,c.cus_address,c.cus_nic,c.cus_mobile,c.location_latitude,c.location_long,c.cus_code');
		$this->db->from('customer c');
		$this->db->join('loan l','c.cus_id=l.cus_id','inner');
		$this->db->where("c.location_status",1);
		$this->db->where("c.cus_status",1);
		$this->db->where("l.route_id",$route_id);
		$this->db->group_by('c.cus_id');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_all_loan_customer_location_updated_with_laons($route_id) {
		$this->db->select('c.cus_id,c.cus_name,c.cus_address,c.cus_nic,c.cus_mobile,c.location_latitude,c.location_long,c.cus_code');
		$this->db->from('customer c');
		$this->db->join('loan l','c.cus_id=l.cus_id','inner');
		$this->db->where("c.location_status",1);
		$this->db->where("c.cus_status",1);
		$this->db->where("l.is_closed",0);
		$this->db->where("l.approval_status",1);
		$this->db->where("l.route_id",$route_id);
		$this->db->group_by('c.cus_id');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	public function get_rep_transaction_location_map($route_id,$date)
	 {
		$this->db->select('v.*');
		$this->db->select('c.cus_name');
		$this->db->select('u.user_first_name');
		$this->db->from('visit_location v');
		$this->db->join('customer c','v.cus_id=c.cus_id','left');
		$this->db->join('user u','v.user_id=u.user_id','left');
		$this->db->where("v.route_id", $route_id);
		$this->db->where("v.date", $date);
		$this->db->where("v.transaction",0);		
		$this->db->order_by("v.time", "desc");
		//$this->db->group_by("v.cus_id");
		$query = $this->db->get();
		return $query->result_array(); 
	 }
	 
	 public function get_rep_visit_location_map($route_id,$date)
	 {
		$this->db->select('v.*');
		$this->db->select('c.cus_name');
		$this->db->select('u.user_first_name');
		$this->db->from('visit_location v');
		$this->db->join('customer c','v.cus_id=c.cus_id','left');
		$this->db->join('user u','v.user_id=u.user_id','left');
		$this->db->where("v.route_id", $route_id);
		$this->db->where("v.date", $date);
		$this->db->where("v.transaction",1);		
		$this->db->order_by("v.time", "desc");
		$query = $this->db->get();
		return $query->result_array(); 
	 }
	 
	 public function get_transaction_count($cus_id,$date)
	 {	
		$this->db->select('v.cus_id');		
		$this->db->from('visit_location v');		
		$this->db->where("v.cus_id", $cus_id);
		$this->db->where("v.date", $date);
		$this->db->where("v.transaction",0);		
		$query = $this->db->get();		
		return $query->num_rows(); 
		 
	 }
	 
	 public function get_visit_count($cus_id,$date)
	 {	
		$this->db->select('v.cus_id');		
		$this->db->from('visit_location v');		
		$this->db->where("v.cus_id", $cus_id);
		$this->db->where("v.date", $date);
		$this->db->where("v.transaction",1);		
		$query = $this->db->get();		
		return $query->num_rows(); 
		 
	 }
	 
	  public function get_visit_transaction_details_all($route_id,$selected_date)
	 {
		$this->db->select('v.*');
		$this->db->select('c.cus_name');
		$this->db->select('u.user_first_name');
		$this->db->from('visit_location v');
		$this->db->join('customer c','v.cus_id=c.cus_id','left');
		$this->db->join('user u','v.user_id=u.user_id','left');
		$this->db->where("v.route_id", $route_id);
		$this->db->like('v.system_date_time',$selected_date );		
		$this->db->order_by("v.system_date_time", "asc");
		$query = $this->db->get();
		return $query->result_array(); 
	 }
	 
	 public function get_customer_loan_list($cus_id,$date)
	 {
		$this->db->select('l.loan_id,l.loan_ref,l.loan_tot_amount,l.loan_term_amount,');		
		//$this->db->select('lp.pymnt_amount');	
		$this->db->from('loan l');	
		//$this->db->join('loan_payment lp','l.loan_id=lp.loan_id','left');
		$this->db->where("l.cus_id", $cus_id);
		$this->db->where("l.is_closed", 0);
		//$this->db->where("lp.pymnt_date_time", $date);		
		$query = $this->db->get();		
		return $query->result_array();  
		 
	 }
	 
	 public function get_loan_selected_date_payment($loan_id,$selected_date)
	 {
				
		$this->db->select_sum('pymnt_amount');	
		$this->db->from('loan_payment');	
		$this->db->where("loan_id", $loan_id);
		$this->db->where("pymnt_date_time", $selected_date);		
		$query = $this->db->get();		
		return $query->row_array();   
		 
	 }
	
	
}