<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Holiday_Model extends CI_Model {
  
  private $tableName = 'holiday';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	function save_holiday($data,$id=false)
	{
		if (!$id)
		{
			$this->db->insert($this->tableName,$data);
		}else {
			$this->db->where('id', $id);
			return $this->db->update($this->tableName,$data);
		}
	}
	
	function get_all_holiday() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("holiday_id", "desc");
		$this->db->where("is_deleted",0);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	function get_holidays_between_loan_open_close_date($loop_date)
	{		
		$this->db->from($this->tableName);
		$this->db->where("holiday_date",$loop_date);
		$this->db->where("status",1);
		$this->db->where("is_deleted",0);		
		$query = $this->db->get();
		$rowcount = $query->num_rows();	
		return 	$rowcount;		
	}
	
	function get_holiday_count_between_loan_start_date_and_today($loan_date, $today)
	{
		$this->db->from($this->tableName);
		$this->db->where("holiday_date <=", $today); //("id !=",$id);
		$this->db->where("holiday_date >=", $loan_date); //("id !=",$id);		
		$this->db->where("status",1);
		$this->db->where("is_deleted",0);		
		$query = $this->db->get();
		$rowcount = $query->num_rows();	
		return 	$rowcount;	
		
	}
	
	function get_holiday_count_between_loan_start_date_and_end_date($loan_date, $today)
	{
		$this->db->from($this->tableName);
		$this->db->where("holiday_date <=", $today); //("id !=",$id);
		$this->db->where("holiday_date >=", $loan_date); //("id !=",$id);		
		$this->db->where("status",1);
		$this->db->where("is_deleted",0);		
		$query = $this->db->get();
		$rowcount = $query->num_rows();	
		return 	$rowcount;	
		
	}
	
	function get_holiday_between_loan_start_date_and_end_date($loan_date, $today)
	{
		$this->db->select($this->tableName.'.*');
		$this->db->from($this->tableName);
		$this->db->where("holiday_date <=", $today); //("id !=",$id);
		$this->db->where("holiday_date >=", $loan_date); //("id !=",$id);		
		$this->db->where("status",1);
		$this->db->where("is_deleted",0);		
		$query = $this->db->get();
		return  $query->result();	
		
		
	}
	
	
}