<?php
class Management_Model extends CI_Model {
	 private $tableName = 'user';
  
  
  function __construct() 
  {
   		/* Call the Model constructor */
    	parent::__construct();
        $this->load->database();
        $this->load->helper('url');
        $this->load->library(array('email'));
  }
 
	
   function getLoan($warehouse_id='')
   {
	   $this->db->select('b.*,c.cus_name');
	    $this->db->select('mpt.payment_term_name');
       $this->db->from('loan b');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	    $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
	    $this->db->where("b.approval_status",0);
		$this->db->where("b.is_closed",0);
	   if($warehouse_id){	   
	   $this->db->where("b.warehouse_id",$warehouse_id);//
	   }
	   $this->db->order_by("b.loan_id", "desc");  
	   $query = $this->db->get();	
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }
   
   
   
   
   function getLoan_approved($wareh_id,$start,$length,$search_key_val)
   {
	$this->db->select('b.*,c.cus_name');
	$this->db->select('mpt.payment_term_name');
    $this->db->from('loan b');
	$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	$this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	$this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
	
	  if($search_key_val)
		{			
			if($wareh_id){
			$this->db->where('b.approval_status =1 AND b.is_closed =0 AND b.warehouse_id ='.$wareh_id.' AND c.cus_code LIKE \'%'.$search_key_val.'%\'');
            $this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND b.warehouse_id ='.$wareh_id.' AND c.cus_name LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND b.warehouse_id ='.$wareh_id.' AND c.cus_nic LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND b.warehouse_id ='.$wareh_id.' AND c.cus_mobile LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND b.warehouse_id ='.$wareh_id.' AND b.loan_ref LIKE \'%'.$search_key_val.'%\'');				
			}
			else{
			$this->db->where('b.approval_status =1 AND b.is_closed =0 AND c.cus_code LIKE \'%'.$search_key_val.'%\'');
            $this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND c.cus_name LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND c.cus_nic LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND c.cus_mobile LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where('b.approval_status =1 AND b.is_closed =0 AND b.loan_ref LIKE \'%'.$search_key_val.'%\'');
			}
		}
		else
		{
			$this->db->where("b.approval_status",1);
			$this->db->where("b.is_closed",0);
	  		if($wareh_id)
			{	   
	   		$this->db->where("b.warehouse_id",$wareh_id);//
	   		}		
		}
       $this->db->order_by("b.loan_id", "asc");
       if($start!='' && $length!='')
	   {
        $this->db->limit($length,$start);
       	$query = $this->db->get(); 
      	return $query->result();     		
	   }
		else
		{
			$query = $this->db->get(); 
			return  $query->num_rows();			
		}
   }
   
   
   
   function getLoan_rejected($warehouse_id='')
   {
	   $this->db->select('b.*,c.cus_name');
	    $this->db->select('mpt.payment_term_name');
       $this->db->from('loan b');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	    $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
	    $this->db->where("b.approval_status","-1");
		$this->db->where("b.is_closed",0);
	   if($warehouse_id){	   
	   $this->db->where("b.warehouse_id",$warehouse_id);//
	   }
	   $this->db->order_by("b.loan_id", "desc");
	   $query = $this->db->get();	  
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }
   
   
   
   
   function update_aproval_status($id,$data)
   {
	  $this->db->where('loan_id',$id);
	  $result=$this->db->update('loan',$data);
	  return $result;
	   
   }
   
    function delete_payment($id)
   {
	   if(isset($id)&&$id>0){
	  $this->db->where('paymnt_id',$id);
	  $result=$this->db->delete('loan_payment');
	  }
	  return $result;	   
   }
   
   function delete_panalty($id)
   {
	   if(isset($id)&&$id>0){
	  $this->db->where('id',$id);
	  $result=$this->db->delete('loan_panalty');
	  }
	  else
	  {
		$result=0;  
	  }
	  return $result;	   
   }
   
    function delete_due($id)
   {
	   if(isset($id)&&$id>0){
	  $this->db->where('id',$id);
	  $result=$this->db->delete('loan_due_amount');
	  }
	   else
	  {
		$result=0;  
	  }
	  return $result;	   
   }
   
   function get_panalty_loan_id($id)
   {
	   $this->db->select('p.loan_id');
       $this->db->from('loan_panalty p');
	   $this->db->where("p.id",$id);
	   $query = $this->db->get();
	   if($query->num_rows() >0)
     	{
      	 return $query->row_array();
		}
     	else
     	{
      	 return false;
     	}	 
	   
   }
   
   function get_due_loan_id($id)
   {
	   $this->db->select('d.loan_id');
       $this->db->from('loan_due_amount d');
	   $this->db->where("d.id",$id);
	   $query = $this->db->get();
	   if($query->num_rows() >0)
     	{
      	 return $query->row_array();
		}
     	else
     	{
      	 return false;
     	}		 
	   
   }
   
   function disable_panalty($id)
   {
	  $this->db->where('loan_id',$id);
	  $data=array(
	  'panalty_enable'=>0	  
	  );	  
	  $result=$this->db->update('loan',$data);
	  return $result; 
	   
   }
   
    function enable_panalty($id)
   {
	  $this->db->where('loan_id',$id);
	  $data=array(
	  'panalty_enable'=>1	  
	  );	  
	  $result=$this->db->update('loan',$data);
	  return $result; 
	   
   }
   
   
   function disable_due($id)
   {
	  $this->db->where('loan_id',$id);
	  $data=array(
	  'enable_due'=>0	  
	  );	  
	  $result=$this->db->update('loan',$data);
	  return $result; 
	   
   }
   
    function enable_due($id)
   {
	  $this->db->where('loan_id',$id);
	  $data=array(
	  'enable_due'=>1	  
	  );	  
	  $result=$this->db->update('loan',$data);
	  return $result; 
	   
   }
   
   function update_loan_table_common($id,$data)
   {
	   if($id>0)
	   {
	  $this->db->where('loan_id',$id);
	  $result=$this->db->update('loan',$data);
	   }
	   else
	   {
		 $result=false;  
	   }
	  return $result;	   
   }
   
   function delete_loan ($loan_id)
   {
	   if(isset($loan_id)&&$loan_id>0){
	  $this->db->where('loan_id',$loan_id);
	  $result=$this->db->delete('loan');
	  }
	   else
	  {
		$result=0;  
	  }
	  return $result; 
	   
   }
   
   function delete_all_payment ($loan_id)
   {
	  if(isset($loan_id)&&$loan_id>0){
	  $this->db->where('loan_id',$loan_id);
	  $result=$this->db->delete('loan_payment');
	  }
	   else
	  {
		$result=0;  
	  }
	  return $result;
	   
	   
   }
   
   function delete_all_penelty ($loan_id)
   {
	  if(isset($loan_id)&&$loan_id>0){
	  $this->db->where('loan_id',$loan_id);
	  $result=$this->db->delete('loan_panalty');
	  }
	   else
	  {
		$result=0;  
	  }
	  return $result;
	   
	   
   }
   
   function delete_all_due ($loan_id)
   {
	  if(isset($loan_id)&&$loan_id>0){
	  $this->db->where('loan_id',$loan_id);
	  $result=$this->db->delete('loan_due_amount');
	  }
	   else
	  {
		$result=0;  
	  }
	  return $result;	
	   
	   
   }
   
   
}