<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Management extends CI_Controller {

    var $main_menu_name = "loan";
	var $sub_menu_name = "list_loan";

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Management_Model');
		$this->load->model('Loan_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Bank_Model');
		$this->load->model('Common_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Menu_Model');
		$this->load->model('User_Model');
		$this->load->model('System_Settings_Model');
		$this->load->model('Unit_Model');
		$this->load->model('Menu_Items_List_Model');
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // -------------------------------------------------------------------------------------
	  
	  public function pending_approval()
	{		 
		$data['main_menu_name'] = "loan_approval";
		$data['sub_menu_name'] = "approval_penidng_loan";
        $this->load->view('management_approval_penidng_loan',$data);
	}	  
	  
	  public function get_list_loan_pending_approval($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==2){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Management_Model->getLoan(0);
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
				
				if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}
					$loan_id=$users->loan_id;
					$row[] = $users->loan_id;
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
	                $row[] = $pTname ;					
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_interest.' %';					
					$loan_editable=false;
					$loan_editable=false;
					
					
						$app_status='';						
						if($users->approval_status==1)
						{
							$app_status='<span class="label label-success">Approved</span>';
						}
						if($users->approval_status==0)
						{
							$app_status='<span class="label label-info">Pending</span>';
						}
						if($users->approval_status==(-1))
						{
							$app_status='<span class="label danger">Reject</span>';
						}						
					$row[] = $app_status;	
					$row[] = number_format($users->loan_tot_amount, 2, '.', ',');	
						
					$row[] =number_format($users->loan_payable_total_amount, 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="'.base_url().'loan/details/'.$users->loan_id.'"><i class="fa fa-trash-o"></i> Loan Details</a></li>
							<li><a href="#" onClick="approval('.$users->loan_id.')"><i class="fa fa-file-text-o"></i> Approval</a></li>
							<li><a href="#" onClick="reject('.$users->loan_id.')"><i class="fa fa-file-text-o"></i> Reject</a></li>	
							   <li><a href="' . base_url() . 'loan/loan_modify/' . $users->loan_id . '"><i class="fa fa-trash-o"></i> Update Loan Details</a></li>								
                       </ul></div>';										
				$row[]=$row_action;				
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	   
	public function approved_loan()
	{		 
		$data['main_menu_name'] = "loan_approval";
		$data['sub_menu_name'] = "approved_loan";
        $this->load->view('management_approved_loan',$data);
	}	  
	  
	public function get_list_loan_approved($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==2){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Management_Model->getLoan_approved(0);
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
				if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}
					$loan_id=$users->loan_id;
					$row[] = $users->loan_id;
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
	                $row[] = $pTname ;				
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_interest.' %';					
					$loan_editable=false;
					$loan_editable=false;
					
						$app_status='';						
						if($users->approval_status==1)
						{
							$app_status='<span class="label label-success">Approved</span>';
						}
						if($users->approval_status==0)
						{
							$app_status='<span class="label label-info">Pending</span>';
						}
						if($users->approval_status==(-1))
						{
							$app_status='<span class="label danger">Reject</span>';
						}						
					$row[] = $app_status;	
					$row[] = number_format($users->loan_tot_amount, 2, '.', ',');	
						
					 $row[] =number_format($users->loan_payable_total_amount, 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="'.base_url().'loan/details/'.$users->loan_id.'"><i class="fa fa-trash-o"></i> Loan Details</a></li>
							<li><a href="#" onClick="approval('.$users->loan_id.')"><i class="fa fa-file-text-o"></i> Approval</a></li>
							<li><a href="#" onClick="reject('.$users->loan_id.')"><i class="fa fa-file-text-o"></i> Reject</a></li>
							 <li><a href="' . base_url() . 'loan/loan_modify/' . $users->loan_id . '"><i class="fa fa-trash-o"></i> Update Loan Details</a></li>
									
                       </ul></div>';
										
					$row[]=$row_action;				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;	
	                $data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   
	   
	   //-----------------------------------------------------------------
	   
	   
	   
	   function change_approval_status()
	   {
		   $loan_id=$this->input->get('id');
		   $status=$this->input->get('status');	
		   $user_id=$this->session->userdata('ss_user_id');	
		   date_default_timezone_set('asia/colombo');
		   $date_time=date('Y-m-d H:i:s');
		   $comment=$this->input->get('comment');	   
		   
		   $data=array(
		   'approval_by'=>$user_id,
		   'approval_status'=>$status,
		   'approval_date_time'=>$date_time,
		   'approval_comment'=>$comment,
		   'loan_issue_status'=>1		   
		   );
		   		     
		  $result=$this->Management_Model->update_aproval_status($loan_id,$data);
		  
		  if($result==1)
		  {
			$json_data=array('id'=>$loan_id,'error'=>'0','message'=>'Approved Successfully'); 
		  }
		  else
		  {
			$json_data=array('id'=>$loan_id,'error'=>'1','message'=>'Error !');  
		  }
		  
		  echo json_encode($json_data);
		   
	   }
	   
	   //-------------------------------------------------------------------
	   
	   
	   
	   public function rejected_loan()
	{		 
		$data['main_menu_name'] = "loan_approval";
		$data['sub_menu_name'] = "rejected_loan";
        $this->load->view('management_rejected_loan',$data);
	}	  
	  
	public function get_list_loan_rejected($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==10){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Management_Model->getLoan_rejected(0);
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
				
				if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}
					$loan_id=$users->loan_id;
					$row[] = $users->loan_id;
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
	                $row[] = $pTname;					
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_interest.' %';					
					$loan_editable=false;
					$loan_editable=false;
						
					
						$app_status='';						
						if($users->approval_status==1)
						{
							$app_status='<span class="label label-success">Approved</span>';
						}
						if($users->approval_status==0)
						{
							$app_status='<span class="label label-info">Pending</span>';
						}
						if($users->approval_status=="-1")
						{
							$app_status='<span class="label label-danger">Reject</span>';
						}						
					$row[] = $app_status;	
					$row[] = number_format($users->loan_tot_amount, 2, '.', ',');	
					
					 $row[] =number_format($users->loan_payable_total_amount, 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="'.base_url().'loan/details/'.$users->loan_id.'"><i class="fa fa-trash-o"></i> Loan Details</a></li>
							<li><a href="#" onClick="approval('.$users->loan_id.')"><i class="fa fa-file-text-o"></i> Approval</a></li>
							<li><a href="#" onClick="reject('.$users->loan_id.')"><i class="fa fa-file-text-o"></i> Reject</a></li>
									
                       </ul></div>';
										
					$row[]=$row_action;				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;	
	                $data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   
	   
	   //-----------------------------------------------------------------
	
	
	
	
	
	

}