<?php $this->load->view("common/header"); ?>

<!-- end: CSS REQUIRED FOR THIS PAGE ONLY -->
<!-- end: HEAD -->
<!-- start: BODY -->

<body>
<!-- start: HEADER -->
<div class="navbar navbar-inverse navbar-fixed-top"> 
  <!-- start: TOP NAVIGATION CONTAINER -->
  <div class="container">
    <div class="navbar-header"> 
      <!-- start: RESPONSIVE MENU TOGGLER -->
      <button data-target=".navbar-collapse" data-toggle="collapse" class="navbar-toggle" type="button"> <span class="clip-list-2"></span> </button>
      <!-- end: RESPONSIVE MENU TOGGLER --> 
      <!-- start: LOGO -->
      <?php $this->load->view("common/logo"); ?>
      <!-- end: LOGO --> 
    </div>
    <div class="navbar-tools"> 
      <!-- start: TOP NAVIGATION MENU -->
      <?php $this->load->view("common/notifications.php"); ?>
      <!-- end: TOP NAVIGATION MENU --> 
    </div>
  </div>
  <!-- end: TOP NAVIGATION CONTAINER --> 
</div>
<!-- end: HEADER --> 
<!-- start: MAIN CONTAINER -->
<div class="main-container">
  <div class="navbar-content"> 
    <!-- start: SIDEBAR -->
    <?php $this->load->view("common/navigation"); ?>
    <!-- end: SIDEBAR --> 
  </div>
  <!-- start: PAGE -->
  <div class="main-content"> 
    <!-- end: SPANEL CONFIGURATION MODAL FORM -->
    <div class="container"> 
      <!-- start: PAGE HEADER -->
      <div class="row">
        <div class="col-sm-12"> 
          <!-- start: PAGE TITLE & BREADCRUMB -->
          <ol class="breadcrumb">
            <li> <a href="<?php echo base_url('dashboard'); ?>"> Dashboard </a> </li>
            <li> <a href="#"> Loan Reports </a> </li>
            <li class="active"> Loan Arrears Reports </li>
            <li class="search-box">
              <form class="sidebar-search">
                <div class="form-group">
                  <input type="text" placeholder="Start Searching...">
                  <button class="submit"> <i class="clip-search-3"></i> </button>
                </div>
              </form>
            </li>
          </ol>
          <div class="page-header">
            <h3>Loan Arrears Reports</h3>
          </div>
          <p>Please use the table below to navigate or filter the results. </p>
        </div>
      </div>
      <!-- end: PAGE HEADER --> 
      <!-- start: PAGE CONTENT 
                    <!-- start grid -->
      <div class="row">
        <div class="col-md-12"> 
          <!-- start: DYNAMIC TABLE PANEL -->
          <div class="panel panel-default">
            <div class="panel-heading"> <i class="fa fa-external-link-square"></i> Loan Arrears Reports
              <div class="panel-tools" style="top:2px;">
              <!--------------------->
               <input type="button" onClick="printDiv('printableArea')" value="Print Summary Report" class="pull-right"/>
              <!--------------------->
              </div>
            </div>
          </div>
          <div class="panel-body">
            <div class="col-md-2">
              <div class="form-group">
                <label for="loan_payment_term">Payment Term * </label>
                <select  id="loan_payment_term" class="form-control search-select" name="loan_payment_term" >
                  <option   value="">ALL</option>
                  <?php 						
						foreach ($payment_term_list as $row)
							{ ?>
                  <option value="<?php echo $row['id'];?>"><?php echo $row['payment_term_name'];?></option>
                  <?php }  ?>
                </select>
              </div>
            </div>
            <div class="col-sm-2">
              <div class="form-group">
                <label>Route </label>
                <select id="route_id" class="form-control search-select" name="route_id">
                  <option value="">ALL</option>
                  <?php foreach ($routes_list as $key) {
									                                echo"<option value=".$key['route_id'].">".$key['route_name']."</option>";
									                             } ?>
                </select>
              </div>
            </div>
            
            <div class="col-sm-1">
              <div class="form-group">
                <label>Terms </label>
                <select id="arr_terms" class="form-control search-select" name="arr_terms">
                  <option value="">ALL</option>
                  <?php for ($i=1;$i<=300;$i++ ) {
									                                echo"<option value=".$i.">".$i."</option>";
									                             } ?>
                </select>
              </div>
            </div>
            <div class="col-sm-2">
              <div class="form-group">
                <!--<label>From Date </label>-->
                <input id="srh_from_date" name="srh_from_date" type='hidden' class="form-control date" value="" data-bv-field="date"/>
              </div>
            </div>
            <div class="col-sm-2">
              <div class="form-group">
               <!-- <label for="s2id_autogen1">To Date </label>-->
                <input id="srh_to_date" name="srh_to_date" type='hidden' class="form-control date" value="" data-bv-field="date"/>
              </div>
            </div>
            <div class="col-sm-3 pull-right">
              <div class="form-group">
                <label for="s2id_autogen1">&nbsp;<br>
                </label>
                <input type="submit" name="add_category" value="Search" class="btn btn-primary" onClick="searchDetails()">
                &nbsp;&nbsp;
                <input type="submit" name="add_category" value="Reset" class="btn btn-danger" onClick="searchDetailsReset()">
              </div>
            </div>
            <div>
              <div id="printableArea">
              <div class="page-header">
              <table class="table table-bordered table-condensed table-hover table-striped dataTable" id="">
               <thead>
               </thead>
               <tbody>
               <tr>
                <td><strong>Loan Arrears Reports</strong></td>
                <td class="text-right"> Date <?php echo date('d-m-Y');?></td>
              </tr>
             
              <tr>
                <td>Total  Arrears </td>
                <td><div id="arrears_amount">Lording....</div></td>
              </tr>
              <tr>
                <td>Total Arrears Installment </td>
                <td><div id="arrears_instalment">Lording....</div></td>
              </tr>
             
               </tbody>
               
               </table>
               
             
              
               </div>
               </div>

               <table class="table table-bordered table-condensed table-hover dataTable" id="products_table">
									  <thead>
							              <tr>
							                  <th>Loan Date</th>
                                              <th>Close Date</th>
											  <th>Reference<br>No.</th>
											  <th>Customer</th>
                                              <th>Payment<br>Term</th> 
                                              <th>Loan <br> Amount</th> 
                                              <th>Rental<br> Amount </th>
                                              <th>No.of<br> Term</th>  
                                              <th>Loan <br>Balance</th>
                                              <th>Arrears<br>Amount</th>  
                                              <th>Arrears <br>instalments</th>                                   
                                             
											                                     
											                                     
                                              
							              </tr>
							          </thead>
							          <tfoot>
											 <tr>
							                  <th>Loan Date</th>
                                              <th>Close Date</th>
											  <th>Reference<br>No.</th>
											  <th>Customer</th>
                                              <th>Payment<br>Term</th> 
                                              <th>Loan <br> Amount</th> 
                                              <th>Rental<br> Amount </th>
                                              <th>No.of<br> Term</th>  
                                              <th>Loan <br>Balance</th>
                                              <th>Arrears<br>Amount</th>  
                                              <th>Arrears <br>instalments</th>                                   
                                             
							              </tr>
                                          </tfoot>
						          </table>
            </div>
          </div>
        </div>
        <!-- end: DYNAMIC TABLE PANEL --> 
      </div>
    </div>
    
    <!-- end grid --> 
    
  </div>
  <!-- end: PAGE --> 
</div>
<!-- end: MAIN CONTAINER --> 
<!-- start: FOOTER -->
<div class="footer clearfix">
  <div class="footer-inner"> <?php echo date("Y"); ?> © A.S.S.K Loan Management System </div>
  <div class="footer-items"> <span class="go-top"><i class="clip-chevron-up"></i></span> </div>
</div>
<!-- end: FOOTER --> 
<!-- start: RIGHT SIDEBAR --> 
<!-- end: RIGHT SIDEBAR -->
<div id="event-management" class="modal fade" tabindex="-1" data-width="760" style="display: none;">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"> &times; </button>
        <h4 class="modal-title">Event Management</h4>
      </div>
      <div class="modal-body"></div>
      <div class="modal-footer">
        <button type="button" data-dismiss="modal" class="btn btn-light-grey"> Close </button>
        <button type="button" class="btn btn-danger remove-event no-display"> <i class='fa fa-trash-o'></i> Delete Event </button>
        <button type='submit' class='btn btn-success save-event'> <i class='fa fa-check'></i> Save </button>
      </div>
    </div>
  </div>
</div>

<!-- start ajax model -->
<div id="ajax-modal" class="modal fade" data-backdrop="static" data-keyboard="false" tabindex="-1" style="display: none;"></div>
<!-- end ajax model --> 

<!-- start: MAIN JAVASCRIPTS -->
<?php $this->load->view("common/footer"); ?>
<!-- end: MAIN JAVASCRIPTS --> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/jquery.dataTables.min.js"></script> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/dataTables.bootstrap.min.js"></script> 
<script type="text/javascript" src="<?php echo base_url('thems/js/bootbox.min.js'); ?>"></script>
<script src="<?php echo asset_url(); ?>js/jquery-ui.js" ></script> 
<script src="<?php echo asset_url(); ?>js/moment-with-locales.js"></script> 
<script type="text/javascript" src="<?php echo asset_url(); ?>js/bootstrap-datetimepicker.js"></script>  
<script type="text/javascript" language="javascript" src="https://cdn.datatables.net/buttons/1.2.3/js/dataTables.buttons.min.js">
	</script> 
<script type="text/javascript" language="javascript" src="//cdn.datatables.net/buttons/1.2.3/js/buttons.print.min.js">
	</script> 
<script type="text/javascript" language="javascript" src="//cdn.datatables.net/buttons/1.2.3/js/buttons.flash.min.js">
	</script> 
<script type="text/javascript" language="javascript" src="//cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js">
	</script> 
<script type="text/javascript" language="javascript" src="//cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/pdfmake.min.js">
	</script> 
<script type="text/javascript" language="javascript" src="//cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/vfs_fonts.js">
	</script> 
<script type="text/javascript" language="javascript" src="//cdn.datatables.net/buttons/1.2.3/js/buttons.html5.min.js">
	</script> 
<script type="text/javascript" language="javascript" src="//cdn.datatables.net/buttons/1.2.3/js/buttons.print.min.js"></script>
<script>
jQuery(document).ready(function() {
//TableData.init();
//loadGrid();
var currentDate = new Date();
var date = new Date();
var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);				
				$('#srh_to_date').datetimepicker({
					defaultDate: currentDate,
					format:"YYYY-MM-DD"
				});				
				$('#srh_from_date').datetimepicker({
					defaultDate: firstDay,
					format:"YYYY-MM-DD"
				});				
				//TableData.init();		
				  $("#route_id").select2();
				//$('#srh_from_date').val('');
				load_cash_instalment_summary();
				loadGrid();
			
});

function load_cash_instalment_summary()
{	
	var route_id=$('#route_id').val();
	var loan_payment_term=$('#loan_payment_term').val();
	var srh_from_date=$('#srh_from_date').val();
	var srh_to_date=$('#srh_to_date').val();
	var arr_terms=$('#arr_terms').val();					 
	$.post( "<?php echo base_url();?>reports_loan/get_loan_arrears_summary", {route_id:route_id, loan_payment_term:loan_payment_term,srh_from_date:srh_from_date,srh_to_date:srh_to_date,arr_terms:arr_terms})
	  .done(function( data ) {	
	  var obj = jQuery.parseJSON(data);	  
	  $('#arrears_amount').text("Rs. "+accounting.formatMoney(obj.arrears_amount, "", 2, ",", "."));
	  $('#arrears_instalment').text(obj.arrears_instalment); 
	 
	  //loadGrid();// load customer data
	  });  
}	
		
function printDiv(divName) 
	{
     var printContents = document.getElementById(divName).innerHTML;
     var originalContents = document.body.innerHTML;
     document.body.innerHTML = printContents;
     window.print();
     document.body.innerHTML = originalContents;
	}
	
	function searchDetailsReset(){
			$('#srh_to_date').val('');
			$('#srh_from_date').val('');
		}
		function searchDetails(){
					load_cash_instalment_summary();
					loadGrid();
					//loadGridSalesReturn();
		}				
				
			

			function loadGrid() {
			var route_id=$('#route_id').val();
			var loan_payment_term=$('#loan_payment_term').val();
			var srh_from_date=$('#srh_from_date').val();
			var srh_to_date=$('#srh_to_date').val();
			var arr_terms=$('#arr_terms').val();						
		$('#products_table').DataTable({	
			dom: 'Blfrtip',
				buttons: [
       		{ extend: 'print', text: 'Print',footer: true},
        	{ extend: 'excel', text: 'Save as Excel',footer: true},
			{ extend: 'pdf', text: 'Save as Pdf',footer: true},
			],						
							"ajax": {
							'type': 'POST',
							'url': '<?php echo base_url('reports_loan/get_loan_arrears_list');?>',
							'data': {
							  route_id:route_id, loan_payment_term:loan_payment_term,srh_from_date:srh_from_date,srh_to_date:srh_to_date,arr_terms:arr_terms
							}
							},
					        "bDestroy": true,
					        "iDisplayLength": 10,
					        "bDestroy": true,
					        "iDisplayLength": 20,
							"order": [[ 10, "asc" ]], "fnFooterCallback": function (nRow, aaData, iStart, iEnd, aiDisplay) {
				
                var pq = 0, sq = 0, bq = 0, pa = 0, grand_tot = 0, tech_tot = 0, parts_tot=0 , ser_tot=0;
				//alert(aaData.length);
				/*var ser_tot3=0;
				var ser_tot2=0;
				var ser_tot1=0;
				var ser_tot4=0;
				var ser_tot5=0;*/
				//var sales_rtn=0;
               /* for (var i = 0; i < aaData.length; i++) 
				{
					//ser_tot1 += parseFloat(aaData[[i]][6]);
					//ser_tot2 += parseFloat(aaData[[i]][7]);
					//ser_tot3 += parseFloat(aaData[[i]][8]);	
					//ser_tot4 += parseFloat(aaData[[i]][9]);
					//ser_tot5 += parseFloat(aaData[[i]][10]);					
                }	*/
/*				 var nCells = nRow.getElementsByTagName('th');
				nCells[6].innerHTML = '<div class="text-right">'+accounting.formatMoney(ser_tot1, "", 2, ",", ".")+' </div>';
				nCells[7].innerHTML = '<div class="text-right">'+accounting.formatMoney(ser_tot2, "", 2, ",", ".")+' </div>';
				nCells[8].innerHTML = '<div class="text-right">'+accounting.formatMoney(ser_tot3, "", 2, ",", ".")+' </div>';
				nCells[9].innerHTML = '<div class="text-right">'+accounting.formatMoney(ser_tot4, "", 2, ",", ".")+' </div>';
				nCells[10].innerHTML = '<div class="text-right">'+accounting.formatMoney(ser_tot5, "", 2, ",", ".")+' </div>';		*/
				             
            }
		});

		}
		
		function printDiv(divName) {
     var printContents = document.getElementById(divName).innerHTML;
     var originalContents = document.body.innerHTML;

     document.body.innerHTML = printContents;

     window.print();

     document.body.innerHTML = originalContents;
}

$(document).on('click',function(event){
	  $('tr').css('background-color','inherit');
	$(event.target).closest('tr').css('background-color','#85C1E9');
});

		
</script>
</body>
<!-- end: BODY -->
</html>