<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports_Loan extends CI_Controller {

    var $main_menu_name = "reports_loan";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();
		
		
		$this->load->model('Loan_Payment_Received_Model');
		$this->load->model('Loan_Model');
		$this->load->model('Reports_Loan_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Bank_Model');
		$this->load->model('Common_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Menu_Model');
		$this->load->model('User_Model');
		$this->load->model('System_Settings_Model');
		$this->load->model('Unit_Model');
		$this->load->model('Menu_Items_List_Model');
		$this->load->model('Route_Model');
		$this->load->model('Report_Loan_Model');
		
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // ------------------------------------------------------------------------------------- new
	  
	  public function rep_loan_daily()
	{
		$data['routes_list']=$this->Route_Model->get_all_active_routes();
		$data['payment_term_list']= $this->Loan_Model->get_loan_payments_term();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "rep_loan_daily";
        $this->load->view('rep_loan_daily',$data);
	}
	
		  
	  
	  public function get_loan_installment_summary($value='')
	{		
		$wareh_id='';
		
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}		
	    $values = $this->Reports_Loan_Model->get_loan_installment_summary_cash($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);
				
			echo json_encode($values);
	   }
	   
	   
	   
	    public function get_loan_installment_list($value='')
	{		
		$wareh_id='';
		
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}		
	    $values = $this->Reports_Loan_Model->get_loan_installment_list_cash($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);
				
			
			
			$columns = array();
	        $data = array();
			//list panalty array start
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					
					$row[] = date('Y-m-d', strtotime($users->pymnt_date_time));
	                $row[] = $users->loan_ref;
					$row[] = $users->payment_term_name;
	                $row[] = $users->cus_name;						
					$row[] = $users->route_name;				  
					$row[] = $users->user_first_name;
					$row[] = $users->capital_received;
					$row[] = $users->loan_interest_recived;
					$row[] = $users->panalty_received;
					$row[] = $users->due_received;
					$row[] = $users->pymnt_amount;
					
					
							
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	   
	   //-------------------------------------------------------------
	    public function rep_close_loan()
		{
		$data['routes_list']=$this->Route_Model->get_all_active_routes();
		$data['payment_term_list']= $this->Loan_Model->get_loan_payments_term();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "rep_close_loan";
        $this->load->view('rep_to_be_close_loan',$data);
		}
	
		  
	  
	  public function get_close_loan_summary($value='')
		{		
		$wareh_id='';		
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}			
	    $values = $this->Reports_Loan_Model->get_close_loan_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);
		
		  $panalty = $this->Reports_Loan_Model->get_close_loan_summary_panalty($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);
		  
		   $due = $this->Reports_Loan_Model->get_close_loan_summary_due($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);
		   
		    $paid = $this->Reports_Loan_Model->get_close_loan_paid_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);
			
			
			$capital_balance=$values['loan_tot_amount']-$paid['capital_received'];
			$income= $paid['loan_interest_recived']+$paid['due_received']+$paid['panalty_received'];
			$net_income=$income-$capital_balance;
			
			
			$total_payble=$values['loan_payable_total_amount']+$panalty['panalty_amount']+$due['due_amount'];
				   
		   $data=array(
		   'loan_tot_amount'=>$values['loan_tot_amount'],
		   'total_interest'=>$values['total_interest'],
		   'loan_payable_total_amount'=>$values['loan_payable_total_amount'],
		   'panalty_amount'=>$panalty['panalty_amount'],
		   'due_amount'=>$due['due_amount'],
		   'capital_received'=>$paid['capital_received'],
		   'loan_interest_recived'=>$paid['loan_interest_recived'],
		   'loan_received'=>$paid['loan_received'],
		   'panalty_received'=>$paid['panalty_received'],
		   'due_received'=>$paid['due_received'],
		   'pymnt_amount'=>$paid['pymnt_amount'],
		   'capital_balance'=>$values['loan_tot_amount']-$paid['capital_received'],
		   'interest_balance'=>$values['total_interest']- $paid['loan_interest_recived'],
		   'panalty_balance'=>$panalty['panalty_amount']- $paid['panalty_received'],
		   'due_balance'=>$due['due_amount']-$paid['due_received'],
		   'total_balane'=>$total_payble-$paid['pymnt_amount'],
		   'total_payble'=>$total_payble,
		   'net_income'=>$net_income
		   
		   );
		
				
		//print_r($values2);
				
			echo json_encode($data);
	   }
	   
	   
	   
	    public function get_close_loan_list($value='')
	{	
		$this->load->model('Loan_Panalty_Process_Model');	
		$this->load->model('Loan_Due_Process_Model');
		
		
		$wareh_id='';		
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}		
	    $values = $this->Reports_Loan_Model->get_close_loan_list($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);
				
			
			
			$columns = array();
	        $data = array();
			//list panalty array start
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
				
				
					if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}					
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}
					
					 $panalty = $this->Loan_Panalty_Process_Model->get_sum_panalty_by_loan_id($users->loan_id);
					 $due = $this->Loan_Due_Process_Model->get_loan_due_sum_by_loan_id($users->loan_id);
					 $payment = $this->Loan_Payment_Received_Model->get_loan_payment_total($users->loan_id);
					 
					 
					 if($panalty['panalty_amount'])
					 {
						 $panalty_amont=$panalty['panalty_amount'];				 
					 }
					 else
					 {
						 $panalty_amont=0;
					 }
					 
					  if($due['due_amount'])
					 {
						 $due_amont=$due['due_amount'];				 
					 }
					 else
					 {
						 $due_amont=0;
					 }
					 
					;
					
					//$row[] = date('Y-m-d', strtotime($users->loan_close_date));
					$row[] = date('Y-m-d', strtotime($users->system_close_date));
	                $row[] = ' <a target="_blank" href="'.base_url().'loan/details/'.$users->loan_id.'">'.$users->loan_ref.'</a>';
					$row[] = $pTname." (".$users->loan_no_of_terms.")";
	                $row[] = $users->cus_name;						
					$row[] = $users->route_name;				  
					$row[] = $users->loan_tot_amount;
					$row[] = $users->total_interest;
					$row[] = $panalty_amont;
					$row[] = $due_amont;				
					$total_payble_amount_loan=$users->loan_payable_total_amount+$panalty['panalty_amount']+$due['due_amount'];
					$balance_amount=$total_payble_amount_loan-$payment['pymnt_amount'];									
					$row[] = number_format($balance_amount, 2, '.', ',');;
					
					
							
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }   
	   //-------------------------------------------------------------
	   
	   //-------------------------------------------------------------
	   //Loan wise summary report with details report
	  public function rep_loan_wise_summary()
	{
		//$data['routes_list']=$this->Route_Model->get_all_active_routes();
		//$data['payment_term_list']= $this->Loan_Model->get_loan_payments_term();
		$data['loan_details']= $this->Report_Loan_Model->get_all_loans(); 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "rep_loan_wise_summary";
        $this->load->view('rep_collection_loan_summary',$data);
	}
	
	 public function get_loan_installment_summary_loan_wise($value='')
	{		
		$wareh_id='';
		
		$loan_id=$this->input->post('loan_id');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}		
	    $values = $this->Report_Loan_Model->get_loan_installment_summary_cash_loan_wise($wareh_id,$loan_id,$srh_from_date,$srh_to_date);				
			echo json_encode($values);
	   }	
	
	 public function get_loan_installment_list_loan_wise($value='')
	{		
		$wareh_id='';		
		$loan_id=$this->input->post('loan_id');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}		
	    $values = $this->Report_Loan_Model->get_loan_installment_list_loan_wise($wareh_id,$loan_id,$srh_from_date,$srh_to_date);			
			$columns = array();
	        $data = array();
			//list panalty array start
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();				
					$status="";
					if($users->pymnt_returned==0)
					{
						$status='<span class="label label-success">ok</span>';
					}
					else
					{
						$status='<span class="label label-danger">returned</span>';
					}					
					$row[] = date('Y-m-d', strtotime($users->pymnt_date_time));
	                $row[] = ' <a target="_blank" href="'.base_url().'loan/details/'.$users->loan_id.'">'.$users->loan_ref.'</a>';
					$row[] = $users->payment_term_name;
	                $row[] = $users->cus_name;						
					$row[] = $users->route_name;				  
					$row[] = $users->user_first_name;
					$row[] = $users->capital_received;
					$row[] = $users->loan_interest_recived;
					$row[] = $users->panalty_received;
					$row[] = $users->due_received;
					$row[] = $users->pymnt_amount;
					$row[] = $status;								
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }	
	//--------------------------------------------------------------
	//--------------------------------------------------------------
	//after close date still not finish loan report
	    public function rep_not_close_loan()
		{
		$data['routes_list']=$this->Route_Model->get_all_active_routes();
		$data['payment_term_list']= $this->Loan_Model->get_loan_payments_term();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "rep_not_close_loan";
        $this->load->view('rep_not_close_loan',$data);
		}		  
	  
	 	public function get_not_close_loan_summary($value='')
		{		
		$wareh_id='';		
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}			
	    $values = $this->Report_Loan_Model->get_not_close_loan_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);		
		  $panalty = $this->Report_Loan_Model->get_not_close_loan_summary_panalty($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);		  
		   $due = $this->Report_Loan_Model->get_not_close_loan_summary_due($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);		   
		    $paid = $this->Report_Loan_Model->get_not_close_loan_paid_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);			
			
			$capital_balance=$values['loan_tot_amount']-$paid['capital_received'];
			$income= $paid['loan_interest_recived']+$paid['due_received']+$paid['panalty_received'];
			$net_income=$income-$capital_balance;			
			$total_payble=$values['loan_payable_total_amount']+$panalty['panalty_amount']+$due['due_amount'];		   
		   
		   $data=array(
		   'loan_tot_amount'=>$values['loan_tot_amount'],
		   'total_interest'=>$values['total_interest'],
		   'loan_payable_total_amount'=>$values['loan_payable_total_amount'],
		   'panalty_amount'=>$panalty['panalty_amount'],
		   'due_amount'=>$due['due_amount'],
		   'capital_received'=>$paid['capital_received'],
		   'loan_interest_recived'=>$paid['loan_interest_recived'],
		   'loan_received'=>$paid['loan_received'],
		   'panalty_received'=>$paid['panalty_received'],
		   'due_received'=>$paid['due_received'],
		   'pymnt_amount'=>$paid['pymnt_amount'],
		   'capital_balance'=>$values['loan_tot_amount']-$paid['capital_received'],
		   'interest_balance'=>$values['total_interest']- $paid['loan_interest_recived'],
		   'panalty_balance'=>$panalty['panalty_amount']- $paid['panalty_received'],
		   'due_balance'=>$due['due_amount']-$paid['due_received'],
		   'total_balane'=>$total_payble-$paid['pymnt_amount'],
		   'total_payble'=>$total_payble,
		   'net_income'=>$net_income		   
		   );				
			echo json_encode($data);
	   }	   
	   
	    public function get_not_close_loan_list($value='')
		{	
		$this->load->model('Loan_Panalty_Process_Model');	
		$this->load->model('Loan_Due_Process_Model');
		$wareh_id='';		
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}		
	    $values = $this->Report_Loan_Model->get_not_close_loan_list($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);					
			$columns = array();
	        $data = array();
			//list panalty array start
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();				
				
					if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}					
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}					
					 $panalty = $this->Loan_Panalty_Process_Model->get_sum_panalty_by_loan_id($users->loan_id);
					 $due = $this->Loan_Due_Process_Model->get_loan_due_sum_by_loan_id($users->loan_id);
					 $payment = $this->Loan_Payment_Received_Model->get_loan_payment_total($users->loan_id);
					 
					 if($panalty['panalty_amount'])
					 {
						 $panalty_amont=$panalty['panalty_amount'];				 
					 }
					 else
					 {
						 $panalty_amont=0;
					 }
					 
					  if($due['due_amount'])
					 {
						 $due_amont=$due['due_amount'];				 
					 }
					 else
					 {
						 $due_amont=0;
					 }					
					//$row[] = date('Y-m-d', strtotime($users->loan_close_date));
					$row[] = date('Y-m-d', strtotime($users->loan_close_date));
	                $row[] = $users->loan_ref;
					$row[] = $pTname." (".$users->loan_no_of_terms.")";
	                $row[] = $users->cus_name;						
					$row[] = $users->route_name;				  
					$row[] = $users->loan_tot_amount;
					$row[] = $users->total_interest;
					$row[] = $panalty_amont;
					$row[] = $due_amont;				
					$total_payble_amount_loan=$users->loan_payable_total_amount+$panalty['panalty_amount']+$due['due_amount'];
					$balance_amount=$total_payble_amount_loan-$payment['pymnt_amount'];									
					$row[] = $balance_amount;
					
					
							
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	 //-------------------------------------------------------------	
	
	 //-------------------------------------------------------------
	 //loan report given time period
	    public function loan_report()
		{
		$data['routes_list']=$this->Route_Model->get_all_active_routes();
		$data['payment_term_list']= $this->Loan_Model->get_loan_payments_term();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "loan_report";
        $this->load->view('rep_loan_report',$data);
		}
		
		public function get_loan_summary($value='')
		{
		$srh_to_date='';
		$srh_from_date='';
				 	
		if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){
			$wareh_id='';			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}					
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');		
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
					
	    $values = $this->Report_Loan_Model->get_loan_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);		
		$panalty = $this->Report_Loan_Model->get_loan_summary_panalty($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);		  
		$due = $this->Report_Loan_Model->get_loan_summary_due($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);						
		$paid = $this->Report_Loan_Model->get_loan_paid_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);			
			
		$capital_balance=$values['loan_tot_amount']-$paid['capital_received'];
		$income= $paid['loan_interest_recived']+$paid['due_received']+$paid['panalty_received'];
		$net_income=$income;			
		$total_payble=$values['loan_payable_total_amount']+$panalty['panalty_amount']+$due['due_amount'];		   
		   
		   $data=array(
		   'loan_tot_amount'=>$values['loan_tot_amount'],
		   'total_interest'=>$values['total_interest'],
		   'loan_payable_total_amount'=>$values['loan_payable_total_amount'],
		   'panalty_amount'=>$panalty['panalty_amount'],
		   'due_amount'=>$due['due_amount'],
		   'capital_received'=>$paid['capital_received'],
		   'loan_interest_recived'=>$paid['loan_interest_recived'],
		   'loan_received'=>$paid['loan_received'],
		   'panalty_received'=>$paid['panalty_received'],
		   'due_received'=>$paid['due_received'],
		   'pymnt_amount'=>$paid['pymnt_amount'],
		   'capital_balance'=>$values['loan_tot_amount']-$paid['capital_received'],
		   'interest_balance'=>$values['total_interest']- $paid['loan_interest_recived'],
		   'panalty_balance'=>$panalty['panalty_amount']- $paid['panalty_received'],
		   'due_balance'=>$due['due_amount']-$paid['due_received'],
		   'total_balane'=>$total_payble-$paid['pymnt_amount'],
		   'total_payble'=>$total_payble,
		   'net_income'=>$net_income		   
		   );				
			echo json_encode($data);
	   }	
	   
	    public function get_loan_list($value='')
		{
		$this->load->model('Loan_Panalty_Process_Model');	
		$this->load->model('Loan_Due_Process_Model');
		$wareh_id='';		
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');
		
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}		
	    $values = $this->Report_Loan_Model->get_not_close_loan_list_2($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);					
			
			
		if($values){
			
			$columns = array();
	        $data = array();
			//list panalty array start
	     
				//-------------------------------------------------------------
	            foreach ($values as $users) {					
	           $row = array();
					$loan_id=$users->loan_id;				
					$payment_term=$users->loan_payment_term;
					$oustanding_value=0;
					$should_be_received_value=0;
					$total_paid_amount=0;	
					$a=0;
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
					$total_panalty=$this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id($loan_id);
					$total_due=$this->Loan_Payment_Received_Model->get_total_due_by_loan_id($loan_id);					
					$total_paid_panalty=$this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id($loan_id);
					$total_paid_due=$this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id($loan_id);
					$total_paid_loan=$this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id($loan_id);	
					//$last_paid=$this->Loan_Payment_Received_Model->get_last_paid_loan_by_loan_id($loan_id);					
					$today=date('Y-m-d');
					$cosingl_date=date('Y-m-d', strtotime($users->loan_close_date));					
					//calcilation start ------------------------------------------------------------------
					$data2=array(
					'loan_id'=>$loan_id ,
					'payment_term'=>$payment_term ,
					'total_paid_amount'=>$total_paid_amount ,
					'total_panalty'=>$total_panalty ,
					'total_due'=>$total_due ,
					'total_paid_panalty'=>$total_paid_panalty ,
					'total_paid_due'=>$total_paid_due ,
					'total_paid_loan'=>$total_paid_loan ,
					'users'=>$users					
					);					
					$oustanding_value=common_outstanding_calculation($data2);					
					// calcilation End ------------------------------------------------------------------
					if($total_panalty['panalty_amount']>0)
					{
					$panalty_charge=$total_panalty['panalty_amount'];	
					}
					else
					{
						$panalty_charge=0;
					}
					if($total_due['due_amount']>0)
					{
					$due_charge=$total_due['due_amount'];	
					}
					else
					{
						$due_charge=0;
					}
					if($total_paid_panalty['panalty_received']>0)
					{
					$paid_panalty_charge=$total_paid_panalty['panalty_received'];	
					}
					else
					{
				$paid_panalty_charge=0;
					}
					if($total_paid_due['due_received']>0)
					{
						$paid_due_charge=$total_paid_due['due_received'];	
					}
					else
					{
					$paid_due_charge=0;
					}
					if($total_paid_loan['loan_received']>0)
					{
						$paid_loan_only=$total_paid_loan['loan_received'];	
					}
					else
					{
					$paid_loan_only=0;
					}		
					if (isset($last_paid['pymnt_amount'])) {
          			  $last_paid = $last_paid['pymnt_amount'];
       					 } else {
           				 $last_paid = 0;
        				}	
					$panalty_charge_total=0;					
					//$last_panalty_details=$this->Loan_Payment_Received_Model->get_last_panalty_by_loan_id($loan_id);			
					//$panalty=$this->Panalty_Model->get_panalty_charge();
					
					  $panalty_charge_total=$panalty_charge;
					
					if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}					
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}	
					
					
					$due_balance=$due_charge-$paid_due_charge;
					$panlty_balance=$panalty_charge_total-$paid_panalty_charge;
					$total_need_to_pay=$users->loan_payable_total_amount+$panalty_charge_total+$due_charge;	
					
					 if($cosingl_date<$today)
					 {
						 $close_status='<span class="label label-yellow">'.date('Y-m-d', strtotime($users->loan_close_date)).'</span>';					
						 $last_outstanding=$oustanding_value+$due_balance+$panlty_balance;
						 
					 }else{
						 
						$close_status='<span class="label label-success">'.date('Y-m-d', strtotime($users->loan_close_date)).'</span>';
						$last_outstanding=$users->loan_payable_total_amount-$paid_loan_only;
					 }					
									
							
	                $row[] =  ' <a target="_blank" href="'.base_url().'loan/details/'.$users->loan_id.'">'.$users->loan_ref.'</a>';
	                $row[] = $users->cus_name;
					$row[] = $users->route_name;
					$row[] = date('Y-m-d', strtotime($users->loan_date));
					$row[] = $close_status;	                
					$row[] = $pTname;
					$row[] = $users->loan_tot_amount;					
					$row[] = $users->total_interest;
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = number_format($last_outstanding, 2, '.', ',');			
					//$row[] = $users->loan_tot_amount;	
					$row[] = number_format($users->loan_payable_total_amount-$paid_loan_only, 2, '.', ',');;
					//$row[]=$row_action;				
				$data[] = $row;
	            }				
				
				//-------------------------------------------------------------
	            $output = array('data' =>$data);
	            echo json_encode($output);
				
		}
		else
		{
			 $output = array('data' =>"");
	            echo json_encode($output);
			
		}
	      
	   }   
		
		//-----------------------------------------------------------
		
		 //-------------------------------------------------------------
	 //loan report given time period
	    public function arrears_report()
		{
		$data['routes_list']=$this->Route_Model->get_all_active_routes();
		$data['payment_term_list']= $this->Loan_Model->get_loan_payments_term();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "rep_loan_arrears";
        $this->load->view('rep_loan_arrears',$data);
		}
		
		public function get_loan_arrears_summary($value='')
		{
		$this->load->model('Panalty_Model');
		
		if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){
			$wareh_id='';			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}			
			$route=$this->input->post('route_id');
		    $payment_t=$this->input->post('loan_payment_term');
			$arr_terms=$this->input->post('arr_terms');				
	        $values = $this->Report_Loan_Model->getLoan_approved_issued($wareh_id,$route,$payment_t);			
	        $data = array();
			$total_oustanging_with_panalty_due=0;					
			$total_arrears_installment_count=0;
			//list panalty array start
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;				
					$payment_term=$users->loan_payment_term;
					$oustanding_value=0;					
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
					$total_panalty=$this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id($loan_id);
					$total_due=$this->Loan_Payment_Received_Model->get_total_due_by_loan_id($loan_id);					
					$total_paid_panalty=$this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id($loan_id);
					$total_paid_due=$this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id($loan_id);
					$total_paid_loan=$this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id($loan_id);	
					$last_paid=$this->Loan_Payment_Received_Model->get_last_paid_loan_by_loan_id($loan_id);				
					//calcilation start ------------------------------------------------------------------
					$data2=array(
					'loan_id'=>$loan_id ,
					'payment_term'=>$payment_term ,
					'total_paid_amount'=>$total_paid_amount ,
					'total_panalty'=>$total_panalty ,
					'total_due'=>$total_due ,
					'total_paid_panalty'=>$total_paid_panalty ,
					'total_paid_due'=>$total_paid_due ,
					'total_paid_loan'=>$total_paid_loan ,
					'users'=>$users					
					);					
					//is_avalable_link(1, 1);
					$oustanding_value=common_outstanding_calculation($data2);					
					// calcilation End ------------------------------------------------------------------					
					 if ($total_panalty['panalty_amount'] > 0) {
            $panalty_charge = $total_panalty['panalty_amount'];
        } else {
            $panalty_charge = 0;
        }
        if ($total_due['due_amount'] > 0) {
            $due_charge = $total_due['due_amount'];
        } else {
            $due_charge = 0;
        }
        if ($total_paid_panalty['panalty_received'] > 0) {
            $paid_panalty_charge = $total_paid_panalty['panalty_received'];
        } else {
            $paid_panalty_charge = 0;
        }
        if ($total_paid_due['due_received'] > 0) {
            $paid_due_charge = $total_paid_due['due_received'];
        } else {
            $paid_due_charge = 0;
        }
        if ($total_paid_loan['loan_received'] > 0) {
            $paid_loan_only = $total_paid_loan['loan_received'];
        } else {
            $paid_loan_only = 0;
        }
		if (isset($last_paid['pymnt_amount'])) {
            $last_paid = $last_paid['pymnt_amount'];
        } else {
            $last_paid = 0;
        }
					$panalty_charge_total=0;					
					//$last_panalty_details=$this->Loan_Payment_Received_Model->get_last_panalty_by_loan_id($loan_id);			
					//$panalty=$this->Panalty_Model->get_panalty_charge();					
					$panalty_charge_total=$panalty_charge;								
					$due_balance=$due_charge-$paid_due_charge;
					$panlty_balance=$panalty_charge_total-$paid_panalty_charge;
					$oustanging_with_panalty_due=$oustanding_value+$due_balance+$panlty_balance;
					$arrears_installment_count =round($oustanding_value/$users->loan_term_amount); 
					
					if($arr_terms){
					if($oustanging_with_panalty_due>0&&$arr_terms==$arrears_installment_count){
					$total_oustanging_with_panalty_due+=$oustanging_with_panalty_due; 
					$total_arrears_installment_count+=$arrears_installment_count; 	               
					}
					}else
					{
					if($oustanging_with_panalty_due>0){
					$total_oustanging_with_panalty_due+=$oustanging_with_panalty_due;
					$total_arrears_installment_count+=$arrears_installment_count; 				
					}				}
	            }
	           $data=array(
		   'arrears_instalment'=>$total_arrears_installment_count,
		   'arrears_amount'=> $total_oustanging_with_panalty_due, 
		   );				
			echo json_encode($data);
	        }else{
	            return NULL;
	        }
	   }	
	   
	    public function get_loan_arrears_list($value='')
		{
		$this->load->model('Panalty_Model');
		
		if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){
			$wareh_id='';			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}			
			$route=$this->input->post('route_id');
		    $payment_t=$this->input->post('loan_payment_term');
			$arr_terms=$this->input->post('arr_terms');
				
	        $values = $this->Report_Loan_Model->getLoan_approved_issued($wareh_id,$route,$payment_t);
			$count=count($values);		
			$totalData =$count;
			$totalFiltered = $totalData; 
			$columns = array();
	        $data = array();
			//list panalty array start
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;				
					$payment_term=$users->loan_payment_term;
					$oustanding_value=0;					
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
					$total_panalty=$this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id($loan_id);
					$total_due=$this->Loan_Payment_Received_Model->get_total_due_by_loan_id($loan_id);					
					$total_paid_panalty=$this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id($loan_id);
					$total_paid_due=$this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id($loan_id);
					$total_paid_loan=$this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id($loan_id);	
					$last_paid=$this->Loan_Payment_Received_Model->get_last_paid_loan_by_loan_id($loan_id);				
					//calcilation start ------------------------------------------------------------------
					$data2=array(
					'loan_id'=>$loan_id ,
					'payment_term'=>$payment_term ,
					'total_paid_amount'=>$total_paid_amount ,
					'total_panalty'=>$total_panalty ,
					'total_due'=>$total_due ,
					'total_paid_panalty'=>$total_paid_panalty ,
					'total_paid_due'=>$total_paid_due ,
					'total_paid_loan'=>$total_paid_loan ,
					'users'=>$users					
					);					
					//is_avalable_link(1, 1);
					$oustanding_value=common_outstanding_calculation($data2);					
					// calcilation End ------------------------------------------------------------------					
					 if ($total_panalty['panalty_amount'] > 0) {
            $panalty_charge = $total_panalty['panalty_amount'];
        } else {
            $panalty_charge = 0;
        }
        if ($total_due['due_amount'] > 0) {
            $due_charge = $total_due['due_amount'];
        } else {
            $due_charge = 0;
        }
        if ($total_paid_panalty['panalty_received'] > 0) {
            $paid_panalty_charge = $total_paid_panalty['panalty_received'];
        } else {
            $paid_panalty_charge = 0;
        }
        if ($total_paid_due['due_received'] > 0) {
            $paid_due_charge = $total_paid_due['due_received'];
        } else {
            $paid_due_charge = 0;
        }
        if ($total_paid_loan['loan_received'] > 0) {
            $paid_loan_only = $total_paid_loan['loan_received'];
        } else {
            $paid_loan_only = 0;
        }
		if (isset($last_paid['pymnt_amount'])) {
            $last_paid = $last_paid['pymnt_amount'];
        } else {
            $last_paid = 0;
        }
					$panalty_charge_total=0;					
					//$last_panalty_details=$this->Loan_Payment_Received_Model->get_last_panalty_by_loan_id($loan_id);			
					//$panalty=$this->Panalty_Model->get_panalty_charge();					
					$panalty_charge_total=$panalty_charge;					
					if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}					
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}					
					$due_balance=$due_charge-$paid_due_charge;
					$panlty_balance=$panalty_charge_total-$paid_panalty_charge;
					$oustanging_with_panalty_due=$oustanding_value+$due_balance+$panlty_balance;
					$arrears_installment_count =round($oustanding_value/$users->loan_term_amount); 
					$total_oustanging_with_panalty_due=0;
					
					
					
					if($arr_terms){
					if($oustanging_with_panalty_due>0&&$arr_terms==$arrears_installment_count){
					$total_oustanging_with_panalty_due+=$oustanging_with_panalty_due; 
					//$total_need_to_pay=$users->loan_payable_total_amount+$panalty_charge_total+$due_charge;	
	                $row[] = $users->loan_date;
					$row[] = $users->loan_close_date;
					$row[] = ' <a href="'.base_url().'loan/details/'.$users->loan_id.'">'.$users->loan_ref.'</a>';
	                $row[] = $users->cus_name." (".$users->cus_phone.")";
					$row[] = $users->loan_tot_amount;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_no_of_terms;	
					$row[] = $pTname;
					$row[] = $users->loan_payable_total_amount-$paid_loan_only;				
					$row[] = number_format($oustanging_with_panalty_due, 2, '.', ',');					
					$row[] = $arrears_installment_count;                					
					$clas='';
					$loan_editable=false;
					$loan_editable=false;
					$data[] = $row;
					}
					}else
					{
						if($oustanging_with_panalty_due>0){
							$total_oustanging_with_panalty_due+=$oustanging_with_panalty_due; 
					//$total_need_to_pay=$users->loan_payable_total_amount+$panalty_charge_total+$due_charge;	
	                $row[] = $users->loan_date;
					$row[] = $users->loan_close_date;
					$row[] = ' <a target="_blank" href="'.base_url().'loan/details/'.$users->loan_id.'">'.$users->loan_ref.'</a>';
	                $row[] = $users->cus_name." (".$users->cus_phone.")";
					$row[] = $users->loan_tot_amount;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_no_of_terms;	
					$row[] = $pTname;
					$row[] = $users->loan_payable_total_amount-$paid_loan_only;				
					$row[] = number_format($oustanging_with_panalty_due, 2, '.', ',');					
					$row[] = $arrears_installment_count;                					
					$clas='';
					$loan_editable=false;
					$loan_editable=false;
					$data[] = $row;
					}
						
						
					}
	            }
	            $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			
			"data"            => $data 
			);

	echo json_encode($json_data); 
	        }else{
	            $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( 0 ),  
			"recordsFiltered" => intval( 0 ),
			"data"            => "" 
			);
	echo json_encode($json_data);
	        }
	   } 
	   
	     
		
		//-----------------------------------------------------------
		
		//-------------------------------------------------------------
	 //capital report given time period
	    public function capital_report()
		{
		$data['routes_list']=$this->Route_Model->get_all_active_routes();
		$data['payment_term_list']= $this->Loan_Model->get_loan_payments_term();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "capital_report";
        $this->load->view('rep_capital_report',$data);
		}
		
		public function get_loan_capital_summary($value='')
		{
		$srh_to_date='';
		$srh_from_date='';
				 	
		if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){
			$wareh_id='';			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}					
		$route_id=$this->input->post('route_id');
		$loan_payment_term=$this->input->post('loan_payment_term');		
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
					
	    $values = $this->Report_Loan_Model->get_loan_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);		
		$panalty = $this->Report_Loan_Model->get_loan_summary_panalty($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);		  
		$due = $this->Report_Loan_Model->get_loan_summary_due($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);						
		$paid = $this->Report_Loan_Model->get_loan_paid_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date);			
			
		$capital_balance=$values['loan_tot_amount']-$paid['capital_received'];
		$income= $paid['loan_interest_recived']+$paid['due_received']+$paid['panalty_received'];
		$net_income=$income-$capital_balance;			
		$total_payble=$values['loan_payable_total_amount']+$panalty['panalty_amount']+$due['due_amount'];		   
		   
		   $data=array(
		   'loan_tot_amount'=>$values['loan_tot_amount'],
		   'total_interest'=>$values['total_interest'],
		   'loan_payable_total_amount'=>$values['loan_payable_total_amount'],
		   'panalty_amount'=>$panalty['panalty_amount'],
		   'due_amount'=>$due['due_amount'],
		   'capital_received'=>$paid['capital_received'],
		   'loan_interest_recived'=>$paid['loan_interest_recived'],
		   'loan_received'=>$paid['loan_received'],
		   'panalty_received'=>$paid['panalty_received'],
		   'due_received'=>$paid['due_received'],
		   'pymnt_amount'=>$paid['pymnt_amount'],
		   'capital_balance'=>$values['loan_tot_amount']-$paid['capital_received'],
		   'interest_balance'=>$values['total_interest']- $paid['loan_interest_recived'],
		   'panalty_balance'=>$panalty['panalty_amount']- $paid['panalty_received'],
		   'due_balance'=>$due['due_amount']-$paid['due_received'],
		   'total_balane'=>$total_payble-$paid['pymnt_amount'],
		   'total_payble'=>$total_payble,
		   'net_income'=>$net_income		   
		   );				
			echo json_encode($data);
	   }	
	    
		
		//-----------------------------------------------------------
		
		
}