<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] 			= 	'login';
$route['404_override'] 					= 	'';
$route['Dashboard'] 					=	'dashboard';
$route['system_settings/categories']	=	'product_category';


//loan
$route['loan']						    =	'loan';
$route['loan/manage/(:any)']				    =	'loan/loan_add/$1';
$route['loan/details/(:any)']				    =	'loan/loan_details/$1';
$route['loan/payments/(:any)']				    =	'loan/loan_payments/$1';
$route['loan/calendar/(:any)']				    =	'loan/loan_calendar/$1';
$route['loan/print_loan_invoice/(:any)']						=	'loan/print_loan_invoice/$1';

//warehouse
$route['warehouse']						    =	'warehouse';

//vehicles
$route['vehicle']						=	'vehicle';
$route['vehicle/manage']						=	'vehicle/vehicle_manage';
$route['vehicle/manage/(:any)']						=	'vehicle/vehicle_manage/$1';
$route['vehicle_service/(:any)/add/(:any)/(:any)']			 =	'vehicle/vehicle_service_add/$1/$1/$1';
$route['vehicle/vehicle_service/(:any)']						=	'vehicle/vehicle_service/$1';
$route['vehicle/print_vehicle_service/(:any)']						=	'vehicle/print_vehicle_service/$1';

//unit
$route['unit']						    =	'unit';
$route['unit/add_unit']				    =	'unit/add_unit';
$route['unit/create_unit']			    =	'unit/create_unit';
$route['unit/delete']				    =	'unit/delete_unit';
$route['unit/disable']				    =	'unit/disable_unit';
$route['unit/enable']				    =	'unit/enable_unit';
$route['unit/save_unit']			    =	'unit/save_unit';
$route['unit/list_unit']			    =	'unit/list_unit';
$route['logout']			            =	'users/logout';


$route['customers']						=	'customers';
$route['products']						=	'products';
$route['products/add']					=	'products/add_product';
$route['users']							=	'users';
$route['users/create']					=	'users/create_user';
$route['users/edit']					=	'users/edit_user';



//report
$route['reports/suppliers'] 				    =	'reports/suppliers';
$route['reports/products'] 				    =	'reports/products';
$route['reports/sales'] 				    =	'reports/sales';
$route['reports/grn'] 				    =	'reports/grn';
$route['reports/user_activitie'] 				    =	'reports/user_activitie';
$route['reports/trial_balance'] 				    =	'reports/trial_balance';



//settings
$route['backups'] 						=	'backups';
$route['system_settings/user_groups'] 	=	'user_groups';
$route['system_settings/permissions/(:num)'] 	=	'user_groups/permissions/$1';

$route['system_settings/menu'] 	=	'menu';
$route['system_settings/menu_items_list'] 	=	'menu_item';

$route["system_settings/subcategories/(:num)"] = "product_category/subcategories/$1";


/* End of file routes.php */
/* Location: ./application/config/routes.php */