<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Loan_Panalty_Process extends CI_Controller {

    var $main_menu_name = "loan_payment_received";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();
		
		$this->load->model('Loan_Panalty_Process_Model');
		$this->load->model('Loan_Payment_Received_Model');
		$this->load->model('Loan_Model');
		$this->load->model('Loan_Issue_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Bank_Model');
		$this->load->model('Common_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Menu_Model');
		$this->load->model('User_Model');
		$this->load->model('System_Settings_Model');
		$this->load->model('Unit_Model');
		$this->load->model('Menu_Items_List_Model');
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // -------------------------------------------------------------------------------------
	  
	
	  public function cal_panalty()
	{
	$details = 'Cron ran at '.date("Y-m-d H:i:s");
	echo $details;
    return false;
	$this->Common_Model->add_log($details);
	
		
		$values = $this->Loan_Panalty_Process_Model->get_active_not_closed_loan();
				
			$columns = array();
	        $data = array();
			//list panalty array start
	        if (!empty($values)) 
			{
	            foreach ($values as $users)
				{
				   //system automatic panalty desabled on requsest by amruna (owner) 2021-05-08
				   //system automatic panalty enable on requsest by amruna (owner) 2022-02-24 
					//-------------------
					if($users->panalty_enable!=0)
					{
					//--------------------					
	                $row = array();
					$loan_id=$users->loan_id;				
					$payment_term=$users->loan_payment_term;
					$oustanding_value=0;
					$should_be_received_value=0;
					$total_paid_amount=0;	
					$a=0;
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
					$total_panalty=$this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id($loan_id);
					$total_due=$this->Loan_Payment_Received_Model->get_total_due_by_loan_id($loan_id);					
					$total_paid_panalty=$this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id($loan_id);
					$total_paid_due=$this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id($loan_id);
					$total_paid_loan=$this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id($loan_id);	
					$last_paid=$this->Loan_Payment_Received_Model->get_last_paid_loan_by_loan_id($loan_id);					
					$today=date('Y-m-d');					
					//calcilation start ------------------------------------------------------------------
					$data2=array(
					'loan_id'=>$loan_id ,
					'payment_term'=>$payment_term ,
					'total_paid_amount'=>$total_paid_amount ,
					'total_panalty'=>$total_panalty ,
					'total_due'=>$total_due ,
					'total_paid_panalty'=>$total_paid_panalty ,
					'total_paid_due'=>$total_paid_due ,
					'total_paid_loan'=>$total_paid_loan ,
					'users'=>$users					
					);					
					$oustanding_value=common_outstanding_calculation($data2);					
					// calcilation End ------------------------------------------------------------------
						if($total_panalty['panalty_amount']>0)
						{
						$panalty_charge=$total_panalty['panalty_amount'];	
						}
						else
						{
						$panalty_charge=0;
						}
					
						if($total_due['due_amount']>0)
						{
						$due_charge=$total_due['due_amount'];	
						}
						else
						{
						$due_charge=0;
						}
					
						if($total_paid_panalty['panalty_received']>0)
						{
						$paid_panalty_charge=$total_paid_panalty['panalty_received'];	
						}
						else
						{
						$paid_panalty_charge=0;
						}
					
						if($total_paid_due['due_received']>0)
						{
						$paid_due_charge=$total_paid_due['due_received'];	
						}
						else
						{
						$paid_due_charge=0;
						}
					
						if($total_paid_loan['loan_received']>0)
						{
						$paid_loan_only=$total_paid_loan['loan_received'];	
						}
						else
						{
						$paid_loan_only=0;
						}				
					//------------------------------------------------------------------
					
				//panalty recode start	
				$panalty_amount=0;
				if($oustanding_value>0)
				{
					$panalty_amount=($oustanding_value/100)*$users->panalty_presentage;
					$data_item=array
						(					
						'loan_id'=> $users->loan_id ,
						'panalty_amount'=>$panalty_amount ,
						'warehouse_id'=>$users->warehouse_id  ,
						'cus_id'=>$users->cus_id  ,
						'route_id'=> $users->route_id ,
						'loan_payment_term'=>$users->loan_payment_term ,
						'payment_date'=>$today,	
						'panalty_precentage'=>$users->panalty_presentage,
						'remark'=>"Daily panalty for outstanding : Rs."	.$oustanding_value			
						);									
					$result=$this->Loan_Panalty_Process_Model->save_today_panalty($data_item);
					
					if($result==0)
					{
						$data_item2=array
						(					
						'loan_id'=> $users->loan_id ,
						'warehouse_id'=>$users->warehouse_id  ,
						'cus_id'=>$users->cus_id  ,
						'route_id'=> $users->route_id ,
						'log'=>"panalty_process_fail" ,			
						);		
				 	$this->Loan_Panalty_Process_Model->save_log($data_item2);
					}
				}				
				//--------------------					
				}//if enable panalty end
				//--------------------				
	            }	            
	        }else{
	           
	        }
	
	
	}
	
	   
	 
	
	
	
	
	

}