<?php if (!defined("BASEPATH")) {
    exit("No direct script access allowed");
}

class Loan_Payment_Received extends CI_Controller
{
    var $main_menu_name = "loan_payment_received";
    var $sub_menu_name = "";

    public function __construct()
    {
        parent::__construct();

        $this->load->model("Panalty_Model");
        $this->load->model("Loan_Payment_Received_Model");
        $this->load->model("Loan_Model");
        $this->load->model("Loan_Issue_Model");
        $this->load->model("Warehouse_Model");
        $this->load->model("Bank_Model");
        $this->load->model("Common_Model");
        $this->load->model("Customer_Model");
        $this->load->model("Menu_Model");
        $this->load->model("User_Model");
        $this->load->model("System_Settings_Model");
        $this->load->model("Unit_Model");
        $this->load->model("Menu_Items_List_Model");
        date_default_timezone_set("asia/colombo");
        $this->load->helper("utility_helper");
    }

    //undifine index
    public function index()
    {
        $data["main_menu_name"] = $this->main_menu_name;
        $data["sub_menu_name"] = $this->sub_menu_name;
        $this->load->view("loan", $data);
    }

    // -------------------------------------------------------------------------------------

    public function payment_pending_list()
    {
        $this->load->model("Route_Model");
        $data["main_menu_name"] = $this->main_menu_name;
        $data["sub_menu_name"] = "payment_pending_list";
        $data[
            "payment_term_list"
        ] = $this->Loan_Model->get_loan_payments_term();
        $data["routes_list"] = $this->Route_Model->get_all_active_routes();
        $this->load->view("payment_pending_list", $data);
    }

    public function get_payment_pending_list($value = "")
    {
        //updated 2019-03-18
        $start = $this->input->get("start");
        $length = $this->input->get("length");
        $search = $this->input->get("search");

        if (
            $this->session->userdata("ss_group_id") == 1 ||
            $this->session->userdata("ss_group_id") == 2
        ) {
            $wareh_id = "";
        } else {
            $wareh_id = $this->session->userdata("ss_warehouse_id");
        }
        $route = $this->input->get("route");
        $payment_t = $this->input->get("payment_t");
        $values = $this->Loan_Issue_Model->getLoan_approved_issued(
            $wareh_id,
            $route,
            $payment_t,
            $start,
            $length,
            $search["value"]
        );
        $count = $this->Loan_Issue_Model->getLoan_approved_issued(
            $wareh_id,
            $route,
            $payment_t,
            "",
            "",
            $search["value"]
        );
        $totalData = $count;
        $totalFiltered = $totalData;
        $columns = [];
        $data = [];
        //list panalty array start
        if (!empty($values)) {
            foreach ($values as $users) {
                $row = [];
                $loan_id = $users->loan_id;
                $payment_term = $users->loan_payment_term;
                $oustanding_value = 0;
                $total_paid_amount = $this->Loan_Model->get_total_paid_by_loan_id(
                    $loan_id
                );
                $total_panalty = $this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id(
                    $loan_id
                );
                $total_due = $this->Loan_Payment_Received_Model->get_total_due_by_loan_id(
                    $loan_id
                );
                $total_paid_panalty = $this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id(
                    $loan_id
                );
                $total_paid_due = $this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id(
                    $loan_id
                );
                $total_paid_loan = $this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id(
                    $loan_id
                );
                $last_paid = $this->Loan_Payment_Received_Model->get_last_paid_loan_by_loan_id(
                    $loan_id
                );
                //calcilation start ------------------------------------------------------------------
                $data2 = [
                    "loan_id" => $loan_id,
                    "payment_term" => $payment_term,
                    "total_paid_amount" => $total_paid_amount,
                    "total_panalty" => $total_panalty,
                    "total_due" => $total_due,
                    "total_paid_panalty" => $total_paid_panalty,
                    "total_paid_due" => $total_paid_due,
                    "total_paid_loan" => $total_paid_loan,
                    "users" => $users,
                ];
                //is_avalable_link(1, 1);
                $oustanding_value = common_outstanding_calculation($data2);
                // calcilation End ------------------------------------------------------------------
                if ($total_panalty["panalty_amount"] > 0) {
                    $panalty_charge = $total_panalty["panalty_amount"];
                } else {
                    $panalty_charge = 0;
                }
                if ($total_due["due_amount"] > 0) {
                    $due_charge = $total_due["due_amount"];
                } else {
                    $due_charge = 0;
                }
                if ($total_paid_panalty["panalty_received"] > 0) {
                    $paid_panalty_charge =
                        $total_paid_panalty["panalty_received"];
                } else {
                    $paid_panalty_charge = 0;
                }
                if ($total_paid_due["due_received"] > 0) {
                    $paid_due_charge = $total_paid_due["due_received"];
                } else {
                    $paid_due_charge = 0;
                }
                if ($total_paid_loan["loan_received"] > 0) {
                    $paid_loan_only = $total_paid_loan["loan_received"];
                } else {
                    $paid_loan_only = 0;
                }
                if (isset($last_paid["pymnt_amount"])) {
                    $last_paid = $last_paid["pymnt_amount"];
                } else {
                    $last_paid = 0;
                }
                $panalty_charge_total = 0;
                $last_panalty_details = $this->Loan_Payment_Received_Model->get_last_panalty_by_loan_id(
                    $loan_id
                );
                $panalty = $this->Panalty_Model->get_panalty_charge();
                $panalty_charge_total = $panalty_charge;
                if ($users->loan_payment_term == 4) {
                    $pTname =
                        $users->payment_term_name .
                        " " .
                        $users->loan_payment_term_qty .
                        " days";
                    if ($users->reduce_fron_ceque == 1) {
                        $pTname =
                            $users->payment_term_name . " ( Custom duration ) ";
                    }
                } else {
                    $pTname = $users->payment_term_name;
                }
                $due_balance = $due_charge - $paid_due_charge;
                $panlty_balance = $panalty_charge_total - $paid_panalty_charge;
                $total_need_to_pay =
                    $users->loan_payable_total_amount +
                    $panalty_charge_total +
                    $due_charge;
                $row[] =
                    '<a target="_blank" href="' .
                    base_url() .
                    "loan/details/" .
                    $users->loan_id .
                    '">' .
                    $users->loan_ref .
                    "</a>";
                $row[] = $users->cus_name;
                $row[] = $users->loan_tot_amount;
                $row[] = $users->loan_payable_total_amount - $paid_loan_only;
                $row[] = $users->loan_term_amount;
                $row[] = $last_paid;
                $row[] = number_format(
                    $oustanding_value + $due_balance + $panlty_balance,
                    2,
                    ".",
                    ","
                );
                $row[] = $users->loan_date;
                $row[] = $users->loan_close_date;
                $row[] = $pTname;
                $clas = "";
                $row[] = $users->loan_no_of_terms;
                $loan_editable = false;
                $loan_editable = false;
                $row_action =
                    '<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a target="_blank" href="' .
                    base_url() .
                    "loan/details/" .
                    $users->loan_id .
                    '"> Loan Details</a></li>
						  <li><a target="_blank" href="' .
                    base_url() .
                    "loan_payment_received/loan_payment/" .
                    $users->loan_id .
                    '"><i class="fa fa-file-text-o"></i> Pay Loan  </a></li>									
                       </ul></div>';
                $row[] = $row_action;
                $data[] = $row;
            }
            $json_data = [
                //"draw"            => intval( $requestData['draw'] ),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            ];

            echo json_encode($json_data);
        } else {
            $json_data = [
                //"draw"            => intval( $requestData['draw'] ),
                "recordsTotal" => intval(0),
                "recordsFiltered" => intval(0),
                "data" => "",
            ];
            echo json_encode($json_data);
        }
    }
    //-------------------------------------------------------------
    public function loan_payment()
    {
        //not updated
        $data["main_menu_name"] = $this->main_menu_name;
        $data["sub_menu_name"] = "loan_payment";
        $loan_id = $this->uri->segment("3");
        $data["details"] = $this->Loan_Model->get_loan_details_by_loan_id(
            $loan_id
        );
        $today = date("Y-m-d");
        $users = $data["details"];
        $payment_term = $users["loan_payment_term"];
        $issue_amount = $this->Loan_Payment_Received_Model->get_loan_paid_total_by_loan_id(
            $loan_id
        );
        if ($issue_amount["pymnt_amount"] > 0) {
            $data["pymnt_amount"] = $issue_amount["pymnt_amount"];
        } else {
            $data["pymnt_amount"] = 0;
        }
        $data["bank_list"] = $this->Bank_Model->get_all_bank();
        if ($payment_term == 3) {
            $loan_req_date = $users["loan_date"];
            $date1 = new DateTime($today);
            $date2 = new DateTime($loan_req_date);
            $diff = $date1->diff($date2);
            $mature_month = $diff->format("%y") * 12 + $diff->format("%m");
            $mature_month += 1;
            $loan_term_amount = $users["loan_term_amount"];
            $should_be_received_value = $loan_term_amount * $mature_month;
            $total_loan_amount = $users["loan_tot_amount"];
            if ($should_be_received_value > $total_loan_amount) {
                $should_be_received_value = $total_loan_amount;
            }
        }
        if ($payment_term == 1) {
            $date1 = date_create($users["loan_date"]);
            $date2 = date_create($today);
            $diff = date_diff($date1, $date2);
            $days = $diff->format("%a");
            $mature_days = $days + 1;
            $loan_term_amount = $users["loan_term_amount"];
            $should_be_received_value = $loan_term_amount * $mature_days;
            $total_loan_amount = $users["loan_tot_amount"];
            if ($should_be_received_value > $total_loan_amount) {
                $should_be_received_value = $total_loan_amount;
            }
        }
        if ($payment_term == 2) {
            $date1 = date_create($users["loan_date"]);
            $date2 = date_create($today);
            $diff = date_diff($date1, $date2);
            $days = $diff->format("%a");
            $week = floor($days / 7);
            $mature_week = $week + 1;
            $loan_term_amount = $users["loan_term_amount"];
            $should_be_received_value = $loan_term_amount * $mature_week;
            $total_loan_amount = $users["loan_tot_amount"];
            if ($should_be_received_value > $total_loan_amount) {
                $should_be_received_value = $total_loan_amount;
            }
        }
        if ($payment_term == 4) {
            $d1 = new DateTime($today);
            $d2 = new DateTime($users["loan_date"]);
            $diff = $d2->diff($d1);
            $year_diff = $diff->y;
            $mature_year = $year_diff;
            $loan_term_amount = $users["loan_term_amount"];
            $should_be_received_value = $loan_term_amount * $mature_year;
            $total_loan_amount = $users["loan_tot_amount"];
            if ($should_be_received_value > $total_loan_amount) {
                $should_be_received_value = $total_loan_amount;
            }
        }
        //------------------------------------------------------------------
        $outstanding = $should_be_received_value - $data["pymnt_amount"];
        $data["outstanding"] = $outstanding;
        $this->load->view("loan_payment_update", $data);
    }

    public function get_list_loan_paid_amount_details_by_loan_id()
    {
        $loan_id = $this->input->get("id");
        $values = $this->Loan_Payment_Received_Model->getLoan_paid_list(
            $loan_id
        );
        $columns = [];
        $data = [];
        if (!empty($values)) {
            foreach ($values as $users) {
                $row = [];
                $loan_id = $users->loan_id;
                $row[] = $users->paymnt_id;
                $row[] = $users->pymnt_ref_no;
                $row[] = date("Y-m-d", strtotime($users->pymnt_date_time));
                $row[] = $users->pymnt_paying_by;
                $row[] = $users->pymnt_amount;
                if ($users->pymnt_paying_by == "Cheque") {
                    $row[] = $users->pymnt_cheque_no;
                    $row[] = $users->pymnt_cheque_date;

                    if ($users->pymnt_deposited == 0) {
                        $row[] = "No";
                    } else {
                        $row[] = "Yes";
                    }

                    if ($users->pymnt_returned == 0) {
                        $row[] = "No";
                    } else {
                        $row[] = "Yes";
                    }
                }
                if ($users->pymnt_paying_by == "Cash") {
                    $row[] = "";
                    $row[] = "";
                    $row[] = "";
                    $row[] = "";
                }
                $row[] = $users->user_first_name;
                $row_action = '<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right"> 
                       </ul></div>';
                $row[] = $row_action;
                //$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;
                $data[] = $row;
            }
            $output = ["data" => $data];
            echo json_encode($output);
        } else {
            $output = ["data" => ""];
            echo json_encode($output);
        }
    }
    //-----------------------------------------------------------------

    function update_pay_loan_details()
    {
        $loan_id = $this->input->post("loan_id");
        $cus_id = $this->input->post("cus_id");
        $route_id = $this->input->post("route_id");
        $warehouse_id = $this->input->post("warehouse_id");
        $payment_type = $this->input->post("payment_type");
        $loan_issue_date = $this->input->post("loan_issue_date");
        $cheqe_number = $this->input->post("cheqe_number");
        $chque_date = $this->input->post("chque_date");
        $contact_no = $this->input->post("contact_no");
        $issue_bank = $this->input->post("issue_bank");
        $issue_brnach = $this->input->post("issue_brnach");
        $amount = $this->input->post("amount");
        $payee = $this->input->post("payee");
        if (!$loan_issue_date) {
            $loan_issue_date = date("Y-m-d H:i:s");
        }
        //start : get_data from db relevent to loan
        $details_confirm = $this->Loan_Model->get_loan_details_by_loan_id(
            $loan_id
        );
        $paid = $this->Loan_Payment_Received_Model->get_loan_paid_total_by_loan_id(
            $loan_id
        );
        $total_paid_amount = $this->Loan_Model->get_total_paid_by_loan_id(
            $loan_id
        );
        $total_panalty = $this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id(
            $loan_id
        );
        $total_due = $this->Loan_Payment_Received_Model->get_total_due_by_loan_id(
            $loan_id
        );
        $total_paid_panalty = $this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id(
            $loan_id
        );
        $total_paid_due = $this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id(
            $loan_id
        );
        $total_paid_loan = $this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id(
            $loan_id
        );
        $total_paid_capital = $this->Loan_Payment_Received_Model->get_total_paid_capital_by_loan_id(
            $loan_id
        );
        $total_paid_interest = $this->Loan_Payment_Received_Model->get_total_paid_interest_by_loan_id(
            $loan_id
        );
        //End : get_data from db relevent to loan
        //start:calculate currant recived capital and interest received %
        $tot_loan_amount = $details_confirm["loan_payable_total_amount"];
        $tot_paid_loan = $total_paid_loan["loan_received"];
        $tot_capital = $details_confirm["loan_tot_amount"];
        $tot_interest = $details_confirm["total_interest"];
        $tot_paid_capital = $total_paid_capital["capital_received"];
        $tot_paid_interest = $total_paid_interest["loan_interest_recived"];
        $tot_balance_capital = $tot_capital - $tot_paid_capital;
        $tot_balance_interest = $tot_interest - $tot_paid_interest;
        $tot_balance_loan = $tot_loan_amount - $tot_paid_loan;
        if ($tot_balance_loan == 0) {
            $temp_tot_balance_loan = 1;
        } else {
            $temp_tot_balance_loan = $tot_balance_loan;
        }
        $capital_presentage =
            ($tot_balance_capital / $temp_tot_balance_loan) * 100;
        $interest_presentage =
            ($tot_balance_interest / $temp_tot_balance_loan) * 100;
        //end:calculate currant recived capital and interest received %
        //start : validation amounts
        if ($total_panalty["panalty_amount"] > 0) {
            $panalty_charge = $total_panalty["panalty_amount"];
        } else {
            $panalty_charge = 0;
        }
        if ($total_due["due_amount"] > 0) {
            $due_charge = $total_due["due_amount"];
        } else {
            $due_charge = 0;
        }
        if ($total_paid_panalty["panalty_received"] > 0) {
            $paid_panalty_charge = $total_paid_panalty["panalty_received"];
        } else {
            $paid_panalty_charge = 0;
        }
        if ($total_paid_due["due_received"] > 0) {
            $paid_due_charge = $total_paid_due["due_received"];
        } else {
            $paid_due_charge = 0;
        }
        if ($paid["pymnt_amount"] > 0) {
            $paid_amount = $paid["pymnt_amount"];
        } else {
            $paid_amount = 0;
        }
        //END : validation amounts
        // start : cal due and panalty payment
        $panalty_balance = $panalty_charge - $paid_panalty_charge;
        $due_balance = $due_charge - $paid_due_charge;
        $currant_amount_balance = $amount;
        $total_loan_payment = 0;
        $due_payment = 0;
        $panalty_payment = 0;
        $loan_capital_payment = 0;
        $loan_interest_payment = 0;
        $loan_excess_payment = 0;
        //-------------------------------
        if ($amount > $due_balance) {
            $due_payment = $due_balance;
        } else {
            if ($amount > 0) {
                $due_payment = $amount;
            }
        }
        //-----------------------------------
        $currant_amount_balance = $currant_amount_balance - $due_payment;
        if ($currant_amount_balance > $panalty_balance) {
            $panalty_payment = $panalty_balance;
        } else {
            if ($amount > 0) {
                $panalty_payment = $currant_amount_balance;
            }
        }
        $currant_amount_balance = $currant_amount_balance - $panalty_payment;
        // end : cal due and panalty payment
        //start : cal loan payment

        if ($currant_amount_balance > 0) {
            $total_loan_payment = $currant_amount_balance;
            //start : cal capital and interest payment amount
            $loan_capital_payment = round(
                ($total_loan_payment / 100) * $capital_presentage,
                2
            );
            $loan_interest_payment = round(
                ($total_loan_payment / 100) * $interest_presentage,
                2
            );
            $loan_excess_payment =
                $total_loan_payment -
                $loan_capital_payment -
                $loan_interest_payment;
            //end : cal capital and interest payment amount
        }
        //end : cal loan payment
        $c_pybl_total =
            $details_confirm["loan_payable_total_amount"] +
            $panalty_balance +
            $due_balance;
        $check = $c_pybl_total - $tot_paid_loan;
        if ($amount <= $check + 1 && $amount > 0) {
            if ($payment_type == "Cheque") {
                $data = [
                    "loan_id" => $loan_id,
                    "cus_id" => $details_confirm["cus_id"],
                    "warehouse_id" => $details_confirm["warehouse_id"],
                    "route_id" => $details_confirm["route_id"],
                    "pymnt_paying_by" => $payment_type,
                    "payment_term" => $details_confirm["loan_payment_term"],
                    "pymnt_date_time" => date(
                        "Y-m-d",
                        strtotime($loan_issue_date)
                    ),
                    "pymnt_amount" => $amount,
                    "pymnt_cheque_no" => $cheqe_number,
                    "pymnt_cheque_date" => date(
                        "Y-m-d",
                        strtotime($chque_date)
                    ),
                    "cheque_payee" => $payee,
                    "bank_id" => $issue_bank,
                    "pymnt_branch" => $issue_brnach,
                    "pymnt_added_date_time" => date("Y-m-d H:i:s"),
                    "user_id" => $this->session->userdata("ss_user_id"),
                    "pymnt_collected" => 1,
                    "panalty_received" => $panalty_payment,
                    "due_received" => $due_payment,
                    "loan_received" => $total_loan_payment,
                    "excess_received" => $loan_excess_payment,
                    "capital_received" => $loan_capital_payment,
                    "loan_interest_recived" => $loan_interest_payment,
                    "pymnt_ref_no" => $this->Common_Model->gen_ref_number(
                        "paymnt_id",
                        "loan_payment",
                        "RCPT/"
                    ),
                ];
            } else {
                $data = [
                    "loan_id" => $loan_id,
                    "cus_id" => $details_confirm["cus_id"],
                    "warehouse_id" => $details_confirm["warehouse_id"],
                    "route_id" => $details_confirm["route_id"],
                    "pymnt_paying_by" => $payment_type,
                    "pymnt_date_time" => date(
                        "Y-m-d",
                        strtotime($loan_issue_date)
                    ),
                    "pymnt_amount" => $amount,
                    "pymnt_added_date_time" => date("Y-m-d H:i:s"),
                    "user_id" => $this->session->userdata("ss_user_id"),
                    "pymnt_collected" => 1,
                    "pymnt_deposited" => 1,
                    "panalty_received" => $panalty_payment,
                    "due_received" => $due_payment,
                    "loan_received" => $total_loan_payment,
                    "excess_received" => $loan_excess_payment,
                    "capital_received" => $loan_capital_payment,
                    "loan_interest_recived" => $loan_interest_payment,
                    "pymnt_ref_no" => $this->Common_Model->gen_ref_number(
                        "paymnt_id",
                        "loan_payment",
                        "RCPT/"
                    ),
                ];
            }
            $result1 = $this->Loan_Payment_Received_Model->save_loan_payment(
                $data
            );
            //check whether loan is ready to close and if rady automatical close by the system
            $paid = $this->Loan_Payment_Received_Model->get_loan_paid_total_by_loan_id(
                $loan_id
            );
            if ($paid["pymnt_amount"] > 0) {
                $paid_amount = $paid["pymnt_amount"];
            } else {
                $paid_amount = 0;
            }
            $tot_to_be_payable =
                $tot_loan_amount + $panalty_charge + $due_charge;
            $tot_to_be_pay_balance_amount = $tot_to_be_payable - $paid_amount;

            if ($tot_to_be_pay_balance_amount <= 0) {
                //echo"done";
                $data = [
                    "is_closed" => 1,
                    "system_close_date" => date("Y-m-d"),
                ];
                $result2 = $this->Loan_Payment_Received_Model->update_loan_close_status(
                    $loan_id,
                    $data
                );
            }

            if ($result1 == 1) {
                echo json_encode([
                    "loan_id" => $loan_id,
                    "error" => 0,
                    "msg" => "Successfuly Saved",
                    "tot_to_be_pay_balance_amount" => $tot_to_be_pay_balance_amount,
                    "tot_to_be_payable" => $tot_to_be_payable,
                    "paid_amount" => $paid_amount,
                ]);
            } else {
                echo json_encode([
                    "loan_id" => $loan_id,
                    "error" => 1,
                    "msg" => "Operation Faild",
                    
                ]);
            }
        } else {
            echo json_encode([
                "loan_id" => $loan_id,
                "error" => 2,
                "msg" =>
                    "Payment Amount not match with currant loan. Please check the Amount",
            ]);
        }
    }
    //-----------------------------------------------------------------

    // -------------------------------------------------------------------------------------
    public function issued_loan()
    {
        $data["main_menu_name"] = $this->main_menu_name;
        $data["sub_menu_name"] = "issued_loan";
        $this->load->view("issued_loan", $data);
    }

    public function get_list_loan_issued($value = "")
    {
        $wareh_id = "";
        if ($this->session->userdata("ss_group_id") == 2) {
        } else {
            $wareh_id = $this->session->userdata("ss_warehouse_id");
        }
        $values = $this->Loan_Issue_Model->getLoan_approved_issued(0);
        $columns = [];
        $data = [];
        if (!empty($values)) {
            foreach ($values as $users) {
                $row = [];
                $loan_id = $users->loan_id;
                $row[] = $users->loan_id;
                $row[] =
                    '<a target="_blank" href="' .
                    base_url() .
                    "loan/details/" .
                    $users->loan_id .
                    '">' .
                    $users->loan_ref .
                    "</a>";
                $row[] = $users->cus_name;
                $row[] = $users->loan_date;
                $row[] = $users->payment_term_name;
                $clas = "";
                $row[] = $users->loan_no_of_terms;
                $row[] = $users->loan_term_amount;
                $row[] = $users->loan_interest . " %";
                $loan_editable = false;
                $loan_editable = false;
                $total_paid_amount = 0;
                $total_paid_amount = $this->Loan_Model->get_total_paid_by_loan_id(
                    $loan_id
                );
                $pay_st = "undifine";

                if ($users->loan_issue_status == 0) {
                    $pay_st = '<span class="label label-yellow">Pending</span>';
                }

                if ($users->loan_issue_status == 1) {
                    $pay_st = '<span class="label label-success">Issued</span>';
                }

                if ($users->loan_issue_status == 2) {
                    $pay_st =
                        '<span class="label label-info">Partial Issue</span>';
                }
                $row[] = $pay_st;
                $app_status = "";
                if ($users->approval_status == 1) {
                    $app_status =
                        '<span class="label label-success">Approved</span>';
                }
                if ($users->approval_status == 0) {
                    $app_status =
                        '<span class="label label-info">Pending</span>';
                }
                if ($users->approval_status == -1) {
                    $app_status = '<span class="label danger">Reject</span>';
                }
                $row[] = $app_status;
                $row[] = number_format($users->loan_tot_amount, 2, ".", ",");
                $row[] = number_format($total_paid_amount, 2, ".", ",");
                $row[] = number_format(
                    $users->loan_tot_amount - $total_paid_amount,
                    2,
                    ".",
                    ","
                );
                $row_action =
                    '<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="' .
                    base_url() .
                    "loan/details/" .
                    $users->loan_id .
                    '"> Loan Details</a></li>
						  <li><a href="' .
                    base_url() .
                    "loan_issue/issue_appeoval_loan/" .
                    $users->loan_id .
                    '"><i class="fa fa-file-text-o"></i> Issue The Loan  </a></li>
															
                       </ul></div>';
                $row[] = $row_action;
                $data[] = $row;
            }
            $output = ["data" => $data];
            echo json_encode($output);
        } else {
            $output = ["data" => ""];
            echo json_encode($output);
        }
    }
    //-------------------------------------------------------------

    // -------------------------------------------------------------------------------------

    public function payment_pending_list_cash_collect()
    {
        $this->load->model("Route_Model");
        $data["main_menu_name"] = $this->main_menu_name;
        $data["sub_menu_name"] = "payment_pending_list_cash";
        $data[
            "payment_term_list"
        ] = $this->Loan_Model->get_loan_payments_term();
        $data["routes_list"] = $this->Route_Model->get_all_active_routes();
        $this->load->view("payment_pending_list_cash", $data);
    }
    public function get_payment_pending_list_cash_collect($value = "")
    {
        $start = $this->input->get("start");
        $length = $this->input->get("length");
        $search = $this->input->get("search");
        $route = $this->input->get("route");
        $payment_t = $this->input->get("payment_t");
        if (
            $this->session->userdata("ss_group_id") == 1 ||
            $this->session->userdata("ss_group_id") == 2
        ) {
            $wareh_id = "";
        } else {
            $wareh_id = $this->session->userdata("ss_warehouse_id");
        }

        $values = $this->Loan_Issue_Model->getLoan_approved_issued(
            $wareh_id,
            $route,
            $payment_t,
            $start,
            $length,
            $search["value"]
        );
        $count = $this->Loan_Issue_Model->getLoan_approved_issued(
            $wareh_id,
            $route,
            $payment_t,
            "",
            "",
            $search["value"]
        );
        $totalData = $count;
        $totalFiltered = $totalData;

        $columns = [];
        $data = [];
        if (!empty($values)) {
            foreach ($values as $users) {
                $row = [];
                $loan_id = $users->loan_id;
                $payment_term = $users->loan_payment_term;
                $oustanding_value = 0;
                $should_be_received_value = 0;
                $total_paid_amount = 0;
                $a = 0;
                $total_paid_amount = $this->Loan_Model->get_total_paid_by_loan_id(
                    $loan_id
                );
                $total_panalty = $this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id(
                    $loan_id
                );
                $total_due = $this->Loan_Payment_Received_Model->get_total_due_by_loan_id(
                    $loan_id
                );
                $total_paid_panalty = $this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id(
                    $loan_id
                );
                $total_paid_due = $this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id(
                    $loan_id
                );
                $total_paid_loan = $this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id(
                    $loan_id
                );
                $last_paid = $this->Loan_Payment_Received_Model->get_last_paid_loan_by_loan_id(
                    $loan_id
                );
                $today = date("Y-m-d");
                //calcilation start ------------------------------------------------------------------
                $data2 = [
                    "loan_id" => $loan_id,
                    "payment_term" => $payment_term,
                    "total_paid_amount" => $total_paid_amount,
                    "total_panalty" => $total_panalty,
                    "total_due" => $total_due,
                    "total_paid_panalty" => $total_paid_panalty,
                    "total_paid_due" => $total_paid_due,
                    "total_paid_loan" => $total_paid_loan,
                    "users" => $users,
                ];
                $oustanding_value = common_outstanding_calculation($data2);
                // calcilation End ------------------------------------------------------------------
                if ($total_panalty["panalty_amount"] > 0) {
                    $panalty_charge = $total_panalty["panalty_amount"];
                } else {
                    $panalty_charge = 0;
                }
                if ($total_due["due_amount"] > 0) {
                    $due_charge = $total_due["due_amount"];
                } else {
                    $due_charge = 0;
                }
                if ($total_paid_panalty["panalty_received"] > 0) {
                    $paid_panalty_charge =
                        $total_paid_panalty["panalty_received"];
                } else {
                    $paid_panalty_charge = 0;
                }
                if ($total_paid_due["due_received"] > 0) {
                    $paid_due_charge = $total_paid_due["due_received"];
                } else {
                    $paid_due_charge = 0;
                }
                if ($total_paid_loan["loan_received"] > 0) {
                    $paid_loan_only = $total_paid_loan["loan_received"];
                } else {
                    $paid_loan_only = 0;
                }
                if (isset($last_paid["pymnt_amount"])) {
                    $last_paid = $last_paid["pymnt_amount"];
                } else {
                    $last_paid = 0;
                }
                $panalty_charge_total = 0;
                //$last_panalty_details=$this->Loan_Payment_Received_Model->get_last_panalty_by_loan_id($loan_id);
                $panalty = $this->Panalty_Model->get_panalty_charge();

                $panalty_charge_total = $panalty_charge;

                if ($users->loan_payment_term == 4) {
                    $pTname =
                        $users->payment_term_name .
                        " " .
                        $users->loan_payment_term_qty .
                        " days";
                    if ($users->reduce_fron_ceque == 1) {
                        $pTname =
                            $users->payment_term_name . " ( Custom duration ) ";
                    }
                } else {
                    $pTname = $users->payment_term_name;
                }
                $due_balance = $due_charge - $paid_due_charge;
                $panlty_balance = $panalty_charge_total - $paid_panalty_charge;
                $total_need_to_pay =
                    $users->loan_payable_total_amount +
                    $panalty_charge_total +
                    $due_charge;

                $row[] =
                    '<a target="_blank" href="' .
                    base_url() .
                    "loan/details/" .
                    $users->loan_id .
                    '">' .
                    $users->loan_ref .
                    "</a>";
                $row[] = $users->cus_name;
                $row[] = $users->loan_tot_amount;
                $row[] = $users->loan_payable_total_amount - $paid_loan_only;
                $row[] = $users->loan_term_amount;
                $row[] = $last_paid;
                $row[] = number_format(
                    $oustanding_value + $due_balance + $panlty_balance,
                    2,
                    ".",
                    ","
                );
                $row[] = $users->loan_date;
                $row[] = $users->loan_close_date;
                $row[] = $pTname;
                $clas = "";
                $row[] = $users->loan_no_of_terms;
                $row[] =
                    "<input type='text' id='pay_amount_" .
                    $users->loan_id .
                    "' name='pay_amount' value='0.00' >";

                $loan_editable = false;
                $loan_editable = false;
                //$row[] = number_format($oustanding_value+$due_balance+$panlty_balance, 2, '.', ',');
                //$row[] = number_format($users->loan_payable_total_amount, 2, '.', ',');
                //$row[]="<input type='text' id='pay_amount_".$users->loan_id."' name='pay_amount' value='0.00' >";
                //$row[] =number_format($total_need_to_pay-$total_paid_amount, 2, '.', ',');
                $row_action =
                    '<div class="btn-group text-left">                       
					 <button  class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button" onclick="payment_proceed(' .
                    $users->loan_id .
                    ')">Pay </button>														
                     </div>';
                $row[] = $row_action;
                $data[] = $row;
            }
            $json_data = [
                //"draw"            => intval( $requestData['draw'] ),
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered),
                "data" => $data,
            ];

            echo json_encode($json_data);
        } else {
            $json_data = [
                //"draw"            => intval( $requestData['draw'] ),
                "recordsTotal" => intval(0),
                "recordsFiltered" => intval(0),
                "data" => "",
            ];
            echo json_encode($json_data);
        }
    }

    //-------------------------------------------------------------
}
