<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manual_Adjest extends CI_Controller {

    var $main_menu_name = "manual_adjest";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();

		$this->load->model('Report_Loan_Model');
		$this->load->model('Loan_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Loan_Panalty_Process_Model');
		$this->load->model('Common_Model');
		$this->load->model('Loan_Due_Process_Model');
		$this->load->model('Menu_Model');
		$this->load->model('User_Model');
		$this->load->model('System_Settings_Model');
		$this->load->model('Unit_Model');
		$this->load->model('Menu_Items_List_Model');
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // -------------------------------------------------------------------------------------
	  
	  public function panalty_add()
	{		 
		$data['main_menu_name'] =$this->main_menu_name;
		$data['sub_menu_name'] = "panalty_add";
		$data['loan_details']= $this->Report_Loan_Model->get_all_loans(); 
        $this->load->view('manual_add_panalty',$data);
	}
	
	
	 function panalty_add_save()
	   {
		   $loan_id=$this->input->post('loan_id');
		   $add_date=$this->input->post('add_date');
		   $amount=$this->input->post('amount');
		   $remarks=$this->input->post('remarks');
			
			if(!$add_date)
			{
			$add_date=date("Y-m-d H:i:s");	
			}
			//start : get_data from db relevent to loan
			$details_confirm = $this->Loan_Model->get_loan_details_by_loan_id($loan_id);
			
			if($amount>0&&$loan_id>0)
				{
					
					$data_item=array
						(					
						'loan_id'=> $loan_id ,
						'panalty_amount'=>$amount ,
						'warehouse_id'=>$details_confirm['warehouse_id']  ,
						'cus_id'=>$details_confirm['cus_id']  ,
						'route_id'=> $details_confirm['route_id'] ,
						'loan_payment_term'=>$details_confirm['loan_payment_term'] ,
						'payment_date'=>$add_date,	
						'remark'=>$remarks." (Manual Add)"			
						);									
					$result=$this->Loan_Panalty_Process_Model->save_today_panalty($data_item);
					
					if($result==0)
					{
						$data_item2=array
						(					
						'loan_id'=> $loan_id,
						'warehouse_id'=>$details_confirm['warehouse_id']  ,
						'cus_id'=>$details_confirm['cus_id']  ,
						'route_id'=> $details_confirm['route_id'] ,
						'log'=>"panalty_process_fail" ,			
						);		
				 	$this->Loan_Panalty_Process_Model->save_log($data_item2);
					}
					
					if($result==1){
					echo json_encode(array('loan_id'=>$loan_id,'error'=>0,'msg'=>'Successfuly Saved'));	
					}else{
					echo json_encode(array('loan_id'=>$loan_id,'error'=>1,'msg'=>"Operation Faild"));
					}		
				}
				else{
					echo json_encode(array('loan_id'=>$loan_id,'error'=>1,'msg'=>"Amount Not Valid"));
					
					
				}
	   }
						  
	  
	 
	   
	   
	   
	   //-----------------------------------------------------------------
	   
	   
	   
	   // -------------------------------------------------------------------------------------
	  
	  public function due_add()
	{		 
		$data['main_menu_name'] =$this->main_menu_name;
		$data['sub_menu_name'] = "due_add";
		$data['loan_details']= $this->Report_Loan_Model->get_all_loans(); 
        $this->load->view('manual_add_due',$data);
	}
	
	
	 function due_add_save()
	   {
		   $loan_id=$this->input->post('loan_id');
		   $add_date=$this->input->post('add_date');
		   $amount=$this->input->post('amount');
		   $remarks=$this->input->post('remarks');
			
			if(!$add_date)
			{
			$add_date=date("Y-m-d H:i:s");	
			}
			//start : get_data from db relevent to loan
			$details_confirm = $this->Loan_Model->get_loan_details_by_loan_id($loan_id);
			
			if($amount>0&&$loan_id>0)
				{
					
					
					$data_item=array(					
					'loan_id'=> $loan_id ,
					'due_amount'=>$amount ,
					'warehouse_id'=>$details_confirm['warehouse_id']  ,
					'cus_id'=>$details_confirm['cus_id']  ,
					'route_id'=> $details_confirm['route_id'] ,
					'payment_term'=>$details_confirm['loan_payment_term'] 				
					);									
					$result=$this->Loan_Due_Process_Model->save_today_due($data_item);
					
					if($result==1){
					echo json_encode(array('loan_id'=>$loan_id,'error'=>0,'msg'=>'Successfuly Saved'));	
					}else{
					echo json_encode(array('loan_id'=>$loan_id,'error'=>1,'msg'=>"Operation Faild"));
					}		
				}
				else{
					echo json_encode(array('loan_id'=>$loan_id,'error'=>1,'msg'=>"Amount Not Valid"));
					
					
				}
	   }
						  
	  
	 
	   
	   
	   
	   //-----------------------------------------------------------------
	
	
	
	
	
	

}