<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Loan_Due_Process extends CI_Controller {

    var $main_menu_name = "loan_due_process";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();
		
		$this->load->model('Loan_Due_Process_Model');
		$this->load->model('Loan_Payment_Received_Model');
		$this->load->model('Loan_Model');
		$this->load->model('Loan_Issue_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Bank_Model');
		$this->load->model('Common_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Menu_Model');
		$this->load->model('User_Model');
		$this->load->model('System_Settings_Model');
		$this->load->model('Unit_Model');
		$this->load->model('Menu_Items_List_Model');
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // -------------------------------------------------------------------------------------
	  
	
	  public function cal_due()
	{
			$today=date('Y-m-d');
	        $values = $this->Loan_Due_Process_Model->getLoan_approved_issued($today);
			$data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;				
					$payment_term=$users->loan_payment_term;
					$oustanding_value=0;
					$should_be_received_value=0;
					$total_paid_amount=0;	
					$a=0;
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
					
					
					//monthly outstanding calculate 
					if($payment_term==3)
					{	
						$loan_req_date=$users->loan_date;												
						$date1 = new DateTime($today);
						$date2 = new DateTime($loan_req_date);
						$diff = $date1->diff($date2);
						$mature_month=(($diff->format('%y') * 12) + $diff->format('%m'));
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_month;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}
						$oustanding_value=	$should_be_received_value-$total_paid_amount;	
						$panalty_charge_total=round($oustanding_value*0.03,2);
						$panalty_charge_total=round($panalty_charge_total/30,2);										
					}
					
					//daily outstanding calculate
					if($payment_term==1)
					{					 
						$date1=date_create($users->loan_date);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");
						$mature_days=$days;
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_days;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}	
						$oustanding_value=	$should_be_received_value-$total_paid_amount;
						$panalty_charge_total=round($oustanding_value*0.03,2);											
					}	
					
					//Weekly outstanding calculate
					if($payment_term==2)
					{					 
						$date1=date_create($users->loan_date);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");						
						$week=floor($days/7);					
						$mature_week=$week;
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_week;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}
						$oustanding_value=	$should_be_received_value-$total_paid_amount;
						$panalty_charge_total=round($oustanding_value*0.03,2);
						$panalty_charge_total=round($panalty_charge_total/7,2);												
					}	
					
					//cheque outstanding calculate
					if($payment_term==4)
					{	
						$should_be_received_value=0;
						//if cheque reduce from cheque date
					      if($users->reduce_fron_ceque==1)
						  {							
							$total_realize_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_realize_cheque_for_today_by_loan_id($loan_id,$today);
							$total_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_cheque_for_today_by_loan_id($loan_id,$today);
							$should_be_received_value=$total_cheque_for_today['pymnt_amount'];
							if($total_realize_cheque_for_today['pymnt_amount']>0)
							{
							$realize_cheque_value=$total_realize_cheque_for_today['pymnt_amount'];	
							}else
							{
								$realize_cheque_value=0;
							}												
							$oustanding_value=$should_be_received_value-$realize_cheque_value;
							 $panalty_charge_total=round($oustanding_value*0.03,2);
							$panalty_charge_total=round($panalty_charge_total/$users->loan_payment_term_qty,2);						
						  }
						  else
						  {					  					  
						 $total_realize_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_realize_cheque_for_today_by_loan_id($loan_id,$today);
							if($total_realize_cheque_for_today['pymnt_amount']>0)
							{
							$realize_cheque_value=$total_realize_cheque_for_today['pymnt_amount'];	
							}else
							{
								$realize_cheque_value=0;
							}
							
							$date1=date_create($users->loan_date);
							$date2=date_create($today);
							$diff=date_diff($date1,$date2);
							$days=$diff->format("%a");
							$mature_days=$days;	
							
							if($users->loan_payment_term_qty>0)
							{
								$time_periad=$users->loan_payment_term_qty;
							}else
							{
								$time_periad=1;
							}						
							$term_count=$mature_days/$time_periad;						
							$diff=intval($term_count); 
							$should_be_received_value=$users->loan_term_amount*$diff;	
							
							$total_loan_amount=$users->loan_payable_total_amount;
							if($should_be_received_value>$total_loan_amount)
							{
							$should_be_received_value=$total_loan_amount;
							}																							
							$oustanding_value=$should_be_received_value-$realize_cheque_value;	
							 $panalty_charge_total=round($oustanding_value*0.03,2);
							$panalty_charge_total=round($panalty_charge_total/$users->loan_payment_term_qty,2);				
							
												  
						  }		
						  
						 
					}			
					
					
					//------------------------------------------------------------------			
					
					
					if($oustanding_value>0){
					$data_item=array(					
					'loan_id'=> $users->loan_id ,
					'due_amount'=>$panalty_charge_total ,
					'warehouse_id'=>$users->warehouse_id  ,
					'cus_id'=>$users->cus_id  ,
					'route_id'=> $users->route_id ,
					'payment_term'=>$users->loan_payment_term 				
					);									
					$result=$this->Loan_Due_Process_Model->save_today_due($data_item);
					
				
					}
						
				
				
				
	            }
	           
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	
	   
	 
	
	
	
	
	

}