<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Loan_Payment_Received extends CI_Controller {

    var $main_menu_name = "loan_payment_received";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();
		
		$this->load->model('Panalty_Model');
		$this->load->model('Loan_Payment_Received_Model');
		$this->load->model('Loan_Model');
		$this->load->model('Loan_Issue_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Bank_Model');
		$this->load->model('Common_Model');
		$this->load->model('Customer_Model');
		$this->load->model('Menu_Model');
		$this->load->model('User_Model');
		$this->load->model('System_Settings_Model');
		$this->load->model('Unit_Model');
		$this->load->model('Menu_Items_List_Model');
		date_default_timezone_set('asia/colombo');		
	}
	
	//undifine index
	public function index()
	{ 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('loan',$data);
	}
	
	 // -------------------------------------------------------------------------------------
	  
	  public function payment_pending_list()
	{		 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "payment_pending_list";
        $this->load->view('payment_pending_list',$data);
	}
	
		  
	  
	  public function get_payment_pending_list($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==2){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Loan_Issue_Model->getLoan_approved_issued(0);
			
			//print_r( $values);
			
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;				
					$payment_term=$users->loan_payment_term;
					$oustanding_value=0;
					$should_be_received_value=0;
					$total_paid_amount=0;	
					$a=0;
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
					$total_panalty=$this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id($loan_id);
					$total_due=$this->Loan_Payment_Received_Model->get_total_due_by_loan_id($loan_id);
					
					$total_paid_panalty=$this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id($loan_id);
					$total_paid_due=$this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id($loan_id);
					
					$total_paid_loan=$this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id($loan_id);
					
					
					
					$today=date('Y-m-d');
					
					
					if($total_panalty['panalty_amount']>0)
					{
					$panalty_charge=$total_panalty['panalty_amount'];	
					}
					else
					{
						$panalty_charge=0;
					}
					
					if($total_due['due_amount']>0)
					{
					$due_charge=$total_due['due_amount'];	
					}
					else
					{
						$due_charge=0;
					}
					
					if($total_paid_panalty['panalty_received']>0)
					{
					$paid_panalty_charge=$total_paid_panalty['panalty_received'];	
					}
					else
					{
				$paid_panalty_charge=0;
					}
					
					if($total_paid_due['due_received']>0)
					{
						$paid_due_charge=$total_paid_due['due_received'];	
					}
					else
					{
					$paid_due_charge=0;
					}
					
					if($total_paid_loan['loan_received']>0)
					{
						$paid_loan_only=$total_paid_loan['loan_received'];	
					}
					else
					{
					$paid_loan_only=0;
					}		
					
					
					//monthly outstanding calculate 
					if($payment_term==3)
					{	
						$loan_req_date=$users->loan_date;												
						$date1 = new DateTime($today);
						$date2 = new DateTime($loan_req_date);
						$diff = $date1->diff($date2);
						$mature_month=(($diff->format('%y') * 12) + $diff->format('%m'));
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_month;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}
						$oustanding_value=	$should_be_received_value-$paid_loan_only;										
					}
					
					//daily outstanding calculate
					if($payment_term==1)
					{					 
						$date1=date_create($users->loan_date);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");
						$mature_days=$days;
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_days;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}	
						$oustanding_value=	$should_be_received_value-$paid_loan_only;											
					}	
					
					//Weekly outstanding calculate
					if($payment_term==2)
					{					 
						$date1=date_create($users->loan_date);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");						
						$week=floor($days/7);					
						$mature_week=$week;
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_week;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}
						$oustanding_value=	$should_be_received_value-$paid_loan_only;												
					}	
					
					//cheque outstanding calculate
					if($payment_term==4)
					{	
						$should_be_received_value=0;
						//if cheque reduce from cheque date
					      if($users->reduce_fron_ceque==1)
						  {							
							$total_realize_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_realize_cheque_for_today_by_loan_id($loan_id,$today);
							$total_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_cheque_for_today_by_loan_id($loan_id,$today);
							$should_be_received_value=$total_cheque_for_today['pymnt_amount'];
							if($total_realize_cheque_for_today['pymnt_amount']>0)
							{
							$realize_cheque_value=$total_realize_cheque_for_today['pymnt_amount'];	
							}else
							{
								$realize_cheque_value=0;
							}												
							$oustanding_value=$should_be_received_value-$realize_cheque_value;
						  }
						  else
						  {					  					  
						 $total_realize_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_realize_cheque_for_today_by_loan_id($loan_id,$today);
							if($total_realize_cheque_for_today['pymnt_amount']>0)
							{
							$realize_cheque_value=$total_realize_cheque_for_today['pymnt_amount'];	
							}else
							{
								$realize_cheque_value=0;
							}
							
							$date1=date_create($users->loan_date);
							$date2=date_create($today);
							$diff=date_diff($date1,$date2);
							$days=$diff->format("%a");
							$mature_days=$days;	
							
							if($users->loan_payment_term_qty>0)
							{
								$time_periad=$users->loan_payment_term_qty;
							}else
							{
								$time_periad=1;
							}						
							$term_count=$mature_days/$time_periad;						
							$diff=intval($term_count); 
							$should_be_received_value=$users->loan_term_amount*$diff;	
							
							$total_loan_amount=$users->loan_payable_total_amount;
							if($should_be_received_value>$total_loan_amount)
							{
							$should_be_received_value=$total_loan_amount;
							}																							
							$oustanding_value=$should_be_received_value-$realize_cheque_value;					
							
												  
						  }		
					}			
					
					
					//------------------------------------------------------------------			
					
					
					$panalty_charge_total=0;
					
					$last_panalty_details=$this->Loan_Payment_Received_Model->get_last_panalty_by_loan_id($loan_id);			
					$panalty=$this->Panalty_Model->get_panalty_charge();
					
					  $panalty_charge_total=$panalty_charge;
					
					if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}					
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}			
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
					$row[] = $users->loan_close_date;
	                $row[] = $pTname;					
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = number_format($oustanding_value, 2, '.', ',');	
					$row[] = $panalty_charge_total-$paid_panalty_charge;		
					$row[]=number_format($due_charge-$paid_due_charge, 2, '.', ',');				
					$loan_editable=false;
					$loan_editable=false;								
					$row[] = number_format($oustanding_value+$panalty_charge_total+$due_charge-$paid_panalty_charge-$paid_due_charge, 2, '.', ',');;	
					$row[] = number_format($users->loan_payable_total_amount, 2, '.', ',');	
					$row[]=number_format($total_paid_amount, 2, '.', ',');	
					
					
					$row[] =number_format($users->loan_payable_total_amount-$total_paid_amount+$panalty_charge_total+$due_charge, 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="'.base_url().'loan/details/'.$users->loan_id.'"><i class="fa fa-trash-o"></i> Loan Details</a></li>
						  <li><a href="'.base_url().'loan_payment_received/loan_payment/'.$users->loan_id.'"><i class="fa fa-file-text-o"></i> Pay Loan  </a></li>
															
                       </ul></div>';										
				$row[]=$row_action;				
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	   
	public function loan_payment()
	{		 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "loan_payment";
		$loan_id=$this->uri->segment('3');
		$data['details'] = $this->Loan_Model->get_loan_details_by_loan_id($loan_id);
		$today=date('Y-m-d');
		$users=$data['details'];
				
		$payment_term=$users['loan_payment_term'];
		
		$issue_amount= $this->Loan_Payment_Received_Model->get_loan_paid_total_by_loan_id($loan_id);	
		
		if($issue_amount['pymnt_amount']>0)
		{
			$data['pymnt_amount']=$issue_amount['pymnt_amount'];
		}
		else
		{
			$data['pymnt_amount']=0;
		}		
		$data['bank_list'] = $this->Bank_Model->get_all_bank();
		
		
		
		if($payment_term==3)
					{						
						$loan_req_date=$users['loan_date'];												
						$date1 = new DateTime($today);
						$date2 = new DateTime($loan_req_date);
						$diff = $date1->diff($date2);
						$mature_month=(($diff->format('%y') * 12) + $diff->format('%m'));
						$loan_term_amount=$users['loan_term_amount'];	
						$should_be_received_value=$loan_term_amount*$mature_month;
						$total_loan_amount=$users['loan_tot_amount'];
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}												
					}
					
					
					if($payment_term==1)
					{					 
						$date1=date_create($users['loan_date']);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");
						$mature_days=$days;
						$loan_term_amount=$users['loan_term_amount'];	
						$should_be_received_value=$loan_term_amount*$mature_days;
						$total_loan_amount=$users['loan_tot_amount'];
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}												
					}	
					
					
					if($payment_term==2)
					{					 
						$date1=date_create($users['loan_date']);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");						
						$week=floor($days/7);					
						$mature_week=$week;
						$loan_term_amount=$users['loan_term_amount'];	
						$should_be_received_value=$loan_term_amount*$mature_week;
						$total_loan_amount=$users['loan_tot_amount'];
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}												
					}	
					
					if($payment_term==4)
					{				
						$d1 = new DateTime($today);
						$d2 = new DateTime($users['loan_date']);
						$diff = $d2->diff($d1);
						$year_diff=$diff->y;								
						$mature_year=$year_diff;
						$loan_term_amount=$users['loan_term_amount'];	
						$should_be_received_value=$loan_term_amount*$mature_year;
						$total_loan_amount=$users['loan_tot_amount'];
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}												
					}			
					
					
					//------------------------------------------------------------------			
					
					$outstanding=$should_be_received_value-$data['pymnt_amount'];
		
		
		
		
		
		
		
		$data['outstanding'] = $outstanding;
		
        $this->load->view('loan_payment_update',$data);
	}	  
	  
	public function get_list_loan_paid_amount_details_by_loan_id()
	{	
			$loan_id=$this->input->get('id');
	        $values = $this->Loan_Payment_Received_Model->getLoan_paid_list($loan_id);
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;
					$row[] = $users->paymnt_id;					
					$row[] = $users->pymnt_ref_no;
	                $row[] = date('Y-m-d', strtotime($users->pymnt_date_time));
	                $row[] = $users->pymnt_paying_by;
					$row[] = $users->pymnt_amount;	               
					if($users->pymnt_paying_by=="Cheque")
					{
						$row[] = $users->pymnt_cheque_no;										  
						$row[] = $users->pymnt_cheque_date;
						
						if($users->pymnt_deposited==0)
						{
						$row[] = "No";	
						}
						
						if($users->pymnt_returned==0)
						{
						$row[] = "No";	
						}
					}
					
					if($users->pymnt_paying_by=="Cash")
					{
						$row[] = "";										  
						$row[] = "";
						$row[] = "";	
						$row[] = "";									  
						
					}
					
				
					$row[] = $users->user_first_name;
					
															 
																							
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">                       
									
                       </ul></div>';
										
					$row[]=$row_action;				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;	
	                $data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   } 
	   
	   
	   //-----------------------------------------------------------------
	   
	   
	   
	   function update_pay_loan_details()
	   {
		   $loan_id=$this->input->post('loan_id');
		   $cus_id=$this->input->post('cus_id');
		   $route_id=$this->input->post('route_id');
		   $warehouse_id=$this->input->post('warehouse_id');
		   $payment_type=$this->input->post('payment_type');
		   $loan_issue_date=$this->input->post('loan_issue_date');
		   $cheqe_number=$this->input->post('cheqe_number');
		   $chque_date=$this->input->post('chque_date');
		   $contact_no=$this->input->post('contact_no');
			$issue_bank=$this->input->post('issue_bank');
			$issue_brnach=$this->input->post('issue_brnach');
			$amount=$this->input->post('amount');
			$payee=$this->input->post('payee');
			
			$details_confirm = $this->Loan_Model->get_loan_details_by_loan_id($loan_id);			
			$paid= $this->Loan_Payment_Received_Model->get_loan_paid_total_by_loan_id($loan_id);
			$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
			$total_panalty=$this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id($loan_id);
			$total_due=$this->Loan_Payment_Received_Model->get_total_due_by_loan_id($loan_id);
			
			$total_paid_panalty=$this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id($loan_id);
			$total_paid_due=$this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id($loan_id);
			
			
			if($total_panalty['panalty_amount']>0)
			{
				$panalty_charge=$total_panalty['panalty_amount'];	
			}
			else
			{
				$panalty_charge=0;
			}
					
			if($total_due['due_amount']>0)
			{
				$due_charge=$total_due['due_amount'];	
			}
				else
			{
				$due_charge=0;
			}
			
			
			
			
			if($total_paid_panalty['panalty_received']>0)
			{
				$paid_panalty_charge=$total_paid_panalty['panalty_received'];	
			}
			else
			{
				$paid_panalty_charge=0;
			}
					
			if($total_paid_due['due_received']>0)
			{
				$paid_due_charge=$total_paid_due['due_received'];	
			}
				else
			{
				$paid_due_charge=0;
			}	
			
			
			$panalty_balance=$panalty_charge-$paid_panalty_charge;
			$due_balance=$due_charge-$paid_due_charge;
			
			$currant_amount_balance=$amount;
			$total_loan_payment=0;
			$due_payment=0;
			$panalty_payment=0;
			
			//-------------------------------
			if($amount>$due_balance)
			{
				$due_payment=$due_balance;
			}
			else
			{
				if($amount>0)
				{
					$due_payment=$amount;					
				}				
			}			
			//-----------------------------------
			
			$currant_amount_balance=$currant_amount_balance-$due_payment;
			
			if($currant_amount_balance>$panalty_balance)
			{
				$panalty_payment=$panalty_balance;
			}
			else
			{				
				if($amount>0)
				{
					$panalty_payment=$currant_amount_balance;					
				}				
			}			
			
			$currant_amount_balance=$currant_amount_balance-$panalty_payment;
			
			//------------------------------------
			
			if($currant_amount_balance>0)
			{
				$total_loan_payment=$currant_amount_balance;
			}
			
			
			//-----------------------------------
						
			
			if($paid['pymnt_amount']>0)
			{
			$paid_amount=$paid['pymnt_amount'];
			}
			else
			{
			$paid_amount=0;
			}			
			$check= $details_confirm['loan_payable_total_amount']-$paid_amount+$panalty_balance+$due_balance;
			
			print_r($amount);			
			if($amount<=$check&& $amount>0){
			if($payment_type=="Cheque")
			{
			$data=array(
			'loan_id'=>$loan_id, 
			'cus_id'=>$details_confirm['cus_id'],
			'warehouse_id'=>$details_confirm['warehouse_id'],
			'route_id'=>$details_confirm['route_id'],
			'pymnt_paying_by'=>$payment_type,
			'pymnt_date_time'=>date('Y-m-d', strtotime($loan_issue_date)) ,			
			'pymnt_amount'=>$amount,
			'pymnt_cheque_no'=>$cheqe_number,
			'pymnt_cheque_date'=>date('Y-m-d', strtotime($chque_date)) ,
			'cheque_payee'=>$payee,
			'bank_id'=>$issue_bank,
			'pymnt_branch'=>$issue_brnach,
			'pymnt_added_date_time'=>date("Y-m-d H:i:s"),
			'user_id'=>$this->session->userdata('ss_user_id'),
			'pymnt_collected'=>1,	
			'panalty_received'=>$panalty_payment,
			'due_received'=>$due_payment,
			'loan_received'=>$total_loan_payment	
			);
			}
			else
			{
			$data=array(
			'loan_id'=>$loan_id, 
			'cus_id'=>$details_confirm['cus_id'],
			'warehouse_id'=>$details_confirm['warehouse_id'],
			'route_id'=>$details_confirm['route_id'],
			'pymnt_paying_by'=>$payment_type,
			'pymnt_date_time'=>date('Y-m-d', strtotime($loan_issue_date)) ,			
			'pymnt_amount'=>$amount,			
			'pymnt_added_date_time'=>date("Y-m-d H:i:s"),
			'user_id'=>$this->session->userdata('ss_user_id'),	
			'pymnt_collected'=>1,
			'panalty_received'=>$panalty_payment,
			'due_received'=>$due_payment,
			'loan_received'=>$total_loan_payment	
			
			);			
				
			}			
			$result1=$this->Loan_Payment_Received_Model->save_loan_payment($data);
			
			$issue_amount= $this->Loan_Issue_Model->get_loan_issue_total_by_loan_id($loan_id);	
			
			if($issue_amount['issue_amount']>0)
			{
			$issued_amount=$issue_amount['issue_amount'];
			}
			else
			{
			$issued_amount=0;
			}	
			
			if($details_confirm['loan_tot_amount']==$issued_amount)
			{
				$issue_status=1;
			}
			else
			{
				$issue_status=2;
			}	
			
			$data=array('loan_issue_status'=>$issue_status);
			
			$result2= $this->Loan_Issue_Model->update_loan_issue_status($loan_id,$data);		
			
			if($result1==1&&$result2==1){
			echo json_encode(array('loan_id'=>$loan_id,'error'=>0,'msg'=>'Successfuly_saved'));	
		}else{
			echo json_encode(array('loan_id'=>$loan_id,'error'=>1,'msg'=>"Operation Faild"));
		}
		
			}
			
			else
			{
				echo json_encode(array('loan_id'=>$loan_id,'error'=>2,'msg'=>'Details Miss match. Please check Amount'));	
			}
			
			
	   }
	   
	   
	   
	   //-----------------------------------------------------------------
	   
	   
	  
	  // -------------------------------------------------------------------------------------
	  
	  public function issued_loan()
	{		 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "issued_loan";
        $this->load->view('issued_loan',$data);
	}	  
	  
	  public function get_list_loan_issued($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==2){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Loan_Issue_Model->getLoan_approved_issued(0);
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;
					$row[] = $users->loan_id;
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
	                $row[] = $users->payment_term_name;					
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = $users->loan_interest.' %';					
					$loan_editable=false;
					$loan_editable=false;
					$total_paid_amount=0;	
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);						 
					$pay_st="undifine";
					
					if  ($users->loan_issue_status==0)
					{
						$pay_st = '<span class="label label-yellow">Pending</span>';
					}
					
					if  ($users->loan_issue_status==1)
					{
						$pay_st = '<span class="label label-success">Issued</span>';
					}
					
					if  ($users->loan_issue_status==2)
					{
						$pay_st = '<span class="label label-info">Partial Issue</span>';
					}
					 	$row[] = $pay_st;	
						$app_status='';						
						if($users->approval_status==1)
						{
							$app_status='<span class="label label-success">Approved</span>';
						}
						if($users->approval_status==0)
						{
							$app_status='<span class="label label-info">Pending</span>';
						}
						if($users->approval_status==(-1))
						{
							$app_status='<span class="label danger">Reject</span>';
						}						
					$row[] = $app_status;	
					$row[] = number_format($users->loan_tot_amount, 2, '.', ',');	
					$row[]=number_format($total_paid_amount, 2, '.', ',');	
					$row[] =number_format($users->loan_tot_amount-$total_paid_amount, 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                       <ul role="menu" class="dropdown-menu pull-right">
                           <li><a href="'.base_url().'loan/details/'.$users->loan_id.'"><i class="fa fa-trash-o"></i> Loan Details</a></li>
						  <li><a href="'.base_url().'loan_issue/issue_appeoval_loan/'.$users->loan_id.'"><i class="fa fa-file-text-o"></i> Issue The Loan  </a></li>
															
                       </ul></div>';										
				$row[]=$row_action;				
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	   	 // -------------------------------------------------------------------------------------
	  
	  public function payment_pending_list_cash_collect()
	{		 
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "payment_pending_list_cash";
        $this->load->view('payment_pending_list_cash',$data);
	}
	
		  
	  
	  public function get_payment_pending_list_cash_collect($value='')
	{		
		$wareh_id='';
		if($this->session->userdata('ss_group_id')==2){			
		}else {
			$wareh_id=$this->session->userdata('ss_warehouse_id');
		}
	        $values = $this->Loan_Issue_Model->getLoan_approved_issued(0);
			
			//print_r( $values);
			
			$columns = array();
	        $data = array();
	        if (!empty($values)) {
	            foreach ($values as $users) {					
	            $row = array();
					$loan_id=$users->loan_id;				
					$payment_term=$users->loan_payment_term;
					$oustanding_value=0;
					$should_be_received_value=0;
					$total_paid_amount=0;	
					$a=0;
					$total_paid_amount=$this->Loan_Model->get_total_paid_by_loan_id($loan_id);	
					$total_panalty=$this->Loan_Payment_Received_Model->get_total_panalty_by_loan_id($loan_id);
					$total_due=$this->Loan_Payment_Received_Model->get_total_due_by_loan_id($loan_id);
					
					$total_paid_panalty=$this->Loan_Payment_Received_Model->get_total_paid_panalty_by_loan_id($loan_id);
					$total_paid_due=$this->Loan_Payment_Received_Model->get_total_paid_due_by_loan_id($loan_id);
					
					$total_paid_loan=$this->Loan_Payment_Received_Model->get_total_paid_loan_by_loan_id($loan_id);
					
					
					
					$today=date('Y-m-d');
					
					
					if($total_panalty['panalty_amount']>0)
					{
					$panalty_charge=$total_panalty['panalty_amount'];	
					}
					else
					{
						$panalty_charge=0;
					}
					
					if($total_due['due_amount']>0)
					{
					$due_charge=$total_due['due_amount'];	
					}
					else
					{
						$due_charge=0;
					}
					
					if($total_paid_panalty['panalty_received']>0)
					{
					$paid_panalty_charge=$total_paid_panalty['panalty_received'];	
					}
					else
					{
				$paid_panalty_charge=0;
					}
					
					if($total_paid_due['due_received']>0)
					{
						$paid_due_charge=$total_paid_due['due_received'];	
					}
					else
					{
					$paid_due_charge=0;
					}
					
					if($total_paid_loan['loan_received']>0)
					{
						$paid_loan_only=$total_paid_loan['loan_received'];	
					}
					else
					{
					$paid_loan_only=0;
					}		
					
					
					//monthly outstanding calculate 
					if($payment_term==3)
					{	
						$loan_req_date=$users->loan_date;												
						$date1 = new DateTime($today);
						$date2 = new DateTime($loan_req_date);
						$diff = $date1->diff($date2);
						$mature_month=(($diff->format('%y') * 12) + $diff->format('%m'));
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_month;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}
						$oustanding_value=	$should_be_received_value-$paid_loan_only;										
					}
					
					//daily outstanding calculate
					if($payment_term==1)
					{					 
						$date1=date_create($users->loan_date);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");
						$mature_days=$days;
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_days;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}	
						$oustanding_value=	$should_be_received_value-$paid_loan_only;											
					}	
					
					//Weekly outstanding calculate
					if($payment_term==2)
					{					 
						$date1=date_create($users->loan_date);
						$date2=date_create($today);
						$diff=date_diff($date1,$date2);
						$days=$diff->format("%a");						
						$week=floor($days/7);					
						$mature_week=$week;
						$loan_term_amount=$users->loan_term_amount;	
						$should_be_received_value=$loan_term_amount*$mature_week;
						$total_loan_amount=$users->loan_payable_total_amount;
						if($should_be_received_value>$total_loan_amount)
						{
							$should_be_received_value=$total_loan_amount;
						}
						$oustanding_value=	$should_be_received_value-$paid_loan_only;												
					}	
					
					//cheque outstanding calculate
					if($payment_term==4)
					{	
						$should_be_received_value=0;
						//if cheque reduce from cheque date
					      if($users->reduce_fron_ceque==1)
						  {							
							$total_realize_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_realize_cheque_for_today_by_loan_id($loan_id,$today);
							$total_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_cheque_for_today_by_loan_id($loan_id,$today);
							$should_be_received_value=$total_cheque_for_today['pymnt_amount'];
							if($total_realize_cheque_for_today['pymnt_amount']>0)
							{
							$realize_cheque_value=$total_realize_cheque_for_today['pymnt_amount'];	
							}else
							{
								$realize_cheque_value=0;
							}												
							$oustanding_value=$should_be_received_value-$realize_cheque_value;
						  }
						  else
						  {					  					  
						 $total_realize_cheque_for_today=$this->Loan_Payment_Received_Model->get_total_realize_cheque_for_today_by_loan_id($loan_id,$today);
							if($total_realize_cheque_for_today['pymnt_amount']>0)
							{
							$realize_cheque_value=$total_realize_cheque_for_today['pymnt_amount'];	
							}else
							{
								$realize_cheque_value=0;
							}
							
							$date1=date_create($users->loan_date);
							$date2=date_create($today);
							$diff=date_diff($date1,$date2);
							$days=$diff->format("%a");
							$mature_days=$days;	
							
							if($users->loan_payment_term_qty>0)
							{
								$time_periad=$users->loan_payment_term_qty;
							}else
							{
								$time_periad=1;
							}						
							$term_count=$mature_days/$time_periad;						
							$diff=intval($term_count); 
							$should_be_received_value=$users->loan_term_amount*$diff;	
							
							$total_loan_amount=$users->loan_payable_total_amount;
							if($should_be_received_value>$total_loan_amount)
							{
							$should_be_received_value=$total_loan_amount;
							}																							
							$oustanding_value=$should_be_received_value-$realize_cheque_value;					
							
												  
						  }		
					}			
					
					
					//------------------------------------------------------------------			
					
					
					$panalty_charge_total=0;
					
					$last_panalty_details=$this->Loan_Payment_Received_Model->get_last_panalty_by_loan_id($loan_id);			
					$panalty=$this->Panalty_Model->get_panalty_charge();
					
					  $panalty_charge_total=$panalty_charge;
					
					if($users->loan_payment_term == 4)
					{ 					
					$pTname=$users->payment_term_name. " " .$users->loan_payment_term_qty." days" ;
					if($users->reduce_fron_ceque == 1)
					{
					$pTname=$users->payment_term_name." ( Custom duration ) ";	
					}					
					}
					else
					{
					$pTname=$users->payment_term_name;	
					}			
	                $row[] = $users->loan_ref;
	                $row[] = $users->cus_name;
					$row[] = $users->loan_date;	
					$row[] = $users->loan_close_date;
	                $row[] = $pTname;					
					$clas='';					  
					$row[] = $users->loan_no_of_terms;
					$row[] = $users->loan_term_amount;
					$row[] = number_format($oustanding_value, 2, '.', ',');	
					$row[] = $panalty_charge_total-$paid_panalty_charge;		
					$row[]=number_format($due_charge-$paid_due_charge, 2, '.', ',');				
					$loan_editable=false;
					$loan_editable=false;								
					$row[] = number_format($oustanding_value+$panalty_charge_total+$due_charge-$paid_panalty_charge-$paid_due_charge, 2, '.', ',');;	
					$row[] = number_format($users->loan_payable_total_amount, 2, '.', ',');	
					
					$curr_outatanding=$oustanding_value+$panalty_charge_total+$due_charge-$paid_panalty_charge-$paid_due_charge;
					
					$row[]="<input type='text' id='pay_amount_".$users->loan_id."' name='pay_amount' value='".$curr_outatanding."' >";	
					
					
					$row[] =number_format($users->loan_payable_total_amount-$total_paid_amount+$panalty_charge_total+$due_charge, 2, '.', ',');																				
					$row_action='<div class="btn-group text-left">                       
					 <button  class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button" onclick="payment_proceed('.$users->loan_id.')">Pay </button>
                      
															
                     </div>';										
				$row[]=$row_action;				
				$data[] = $row;
	            }
	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);
	        }
	   }
	   
	   
	   
	   //-------------------------------------------------------------
	   
	 
	
	
	
	
	

}