<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Interest_Rate_Model extends CI_Model {
  
  private $tableName = 'mstr_interest_rate';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }

	function save_interest_rate(&$interest_rate_data,$interest_rate_id=false)
	{
		if (!$interest_rate_id)
		{
			$this->db->insert($this->tableName,$interest_rate_data);
		}else {
			$this->db->where('id', $interest_rate_id);
			return $this->db->update($this->tableName,$interest_rate_data);
		}
	}	
	
	function get_all_interest_rate() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("id", "asc");
		$this->db->where("id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
	}
	
	public function get_interest_rate_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("id", $id);
		$this->db->order_by("id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_interest_rate($interest_rate_id)
	{
		$this->db->where('id', $interest_rate_id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_interest_rate($interest_rate_id)
	{
		$data = array(
			'status' => 0
		);	
		$this->db->where('id', $interest_rate_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_interest_rate($interest_rate_id)
	{
		$data = array(
			'status' => 1
		);	
		$this->db->where('id', $interest_rate_id);
		$this->db->update($this->tableName, $data);
	}
}