<?php
class Loan_Issue_Model extends CI_Model {
	 private $tableName = 'user';
  
  
  function __construct() 
  {
   		/* Call the Model constructor */
    	parent::__construct();
        $this->load->database();
        $this->load->helper('url');
        $this->load->library(array('email'));
  }
 
	function update_loan_issue_status($loan_id,$data)
	{		
		$this->db->where('loan_id', $loan_id);
		return $this->db->update('loan',$data);
		
	}
   

    function get_loan_issue_total_by_loan_id($loan_id)
   {
	$this->db->select_sum('issue_amount');
	$this->db->from('loan_issue');
	$this->db->where('loan_issue.is_return',0);	
	$this->db->where('loan_issue.loan_id',$loan_id);
	$query = $this->db->get();
	return $query->row_array(); 
	   
   }
   
  
  
  
	function save_loan_issue($data)
	{
		if ($data)
		{			
			return $this->db->insert('loan_issue',$data);
		}else{
			return false;	
		}
	}
	
	function getLoan_issued_and_partial_issued($loan_id)
	{
		$this->db->select('loan_issue.*');
		$this->db->select('mstr_bank.bank_code');
		$this->db->from('loan_issue');
		$this->db->join('mstr_bank', 'mstr_bank.bank_id = loan_issue.cheque_bank', 'left');
		$this->db->where('loan_issue.loan_id',$loan_id);
		$query = $this->db->get();
		return $query->result(); 
		
	}
	
	 function getLoan_approved_pending_issue($warehouse_id='')
   {
	   $this->db->select('b.*,c.cus_name');
	    $this->db->select('mpt.payment_term_name');
       $this->db->from('loan b');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	    $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
	    $this->db->where("b.approval_status",1);
		$this->db->where("b.loan_issue_status != 1");
	   if($warehouse_id){	   
	   $this->db->where("b.warehouse_id",$warehouse_id);//
	   }
	   $this->db->order_by("b.loan_id", "desc");
	   $query = $this->db->get();	  
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }
   
   
   function getLoan_approved_issued($warehouse_id,$route,$payment_t,$start,$length,$search_key_val)
   {
	   $this->db->select('b.*,c.cus_name');
	    $this->db->select('mpt.payment_term_name');
       $this->db->from('loan b');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	    $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
		
		$approval_status_con="b.approval_status =1";
		$is_closed_con=" AND b.is_closed =0";
		$loan_issue_status_con=" AND b.loan_issue_status =1";
		
		$loan_payment_term_con="";	
		$route_id_con="";
		$warehouse_id_con="";	
	 	
		if($warehouse_id){
		$warehouse_id_con=" AND b.warehouse_id =".$warehouse_id." ";			
		}		
		if($route){
		$route_id_con=" AND b.route_id =".$route." ";	
		}		
		if($payment_t){
		$loan_payment_term_con=" AND b.loan_payment_term =".$payment_t." ";	
		}		
		$where_condition=$approval_status_con.$is_closed_con.$warehouse_id_con.$route_id_con.$loan_payment_term_con.$loan_issue_status_con;
		
		if($search_key_val)
		{
			$this->db->where($where_condition.' AND c.cus_code LIKE \'%'.$search_key_val.'%\'');
            $this->db->or_where($where_condition.' AND c.cus_name LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where($where_condition.' AND c.cus_nic LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where($where_condition.' AND c.cus_mobile LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where($where_condition.' AND b.loan_ref LIKE \'%'.$search_key_val.'%\'');				
		}
		else
		{
			$this->db->where($where_condition);
		}
		$this->db->order_by("b.loan_id", "desc");
       if($start!='' && $length!='')
	   {
        $this->db->limit($length,$start);
       	$query = $this->db->get(); 
      	return $query->result();     		
	   }
		else
		{
			$query = $this->db->get(); 
			return  $query->num_rows();			
		}
		
	  
   }
	
	
  
   
   
   
}