<?php
class Report_Loan_Model extends CI_Model {
	 private $tableName = 'user';
  
  
  function __construct() 
  {
   		/* Call the Model constructor */
    	parent::__construct();
        $this->load->database();
        $this->load->helper('url');
        //$this->load->library(array('email'));
  }
 
	//---------------------------------------------
	//REF : loan instalment report
	 public function get_all_loans()
	 {
		 $this->db->select('loan.loan_id,loan.loan_ref,loan.loan_tot_amount,loan.is_closed');
		 $this->db->select('c.cus_name, c.cus_nic');
		 $this->db->from('loan');
		 $this->db->join('customer c', 'c.cus_id = loan.cus_id', 'left');
		 $query = $this->db->get();
		 return $query->result_array(); 		 
	 }
	 
	  function get_loan_installment_summary_cash_loan_wise($wareh_id,$loan_id,$srh_from_date,$srh_to_date)
   {
	   $this->db->select_sum('b.loan_received');
	   $this->db->select_sum('b.capital_received');
	    $this->db->select_sum('b.loan_interest_recived');
		$this->db->select_sum('b.panalty_received');
		$this->db->select_sum('b.due_received');
		$this->db->select_sum('b.excess_received');
		$this->db->select_sum('b.pymnt_amount');
       $this->db->from('loan_payment b');
	   //$this->db->where("b.pymnt_paying_by","Cash");
	   $this->db->where("b.pymnt_collected",1);
	   $this->db->where("b.pymnt_returned",0);   
	  
	  	   
	   $this->db->where("b.loan_id",$loan_id);
	 
	  
	    if($srh_from_date){	   
	    $this->db->where("b.pymnt_date_time >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.pymnt_date_time <=",$srh_to_date);
	   }
	   
	   
	   $query = $this->db->get();	  
     if($query->num_rows() >0)
     {
       return $query->row_array();
     }
     else
     {
       return false;
     }
   }
   
   
   	 function get_loan_installment_list_loan_wise($wareh_id,$loan_id,$srh_from_date,$srh_to_date)
   {
	   $this->db->select('c.cus_name');
	   $this->db->select('l.loan_ref');
	   $this->db->select('b.*');
	   $this->db->select('u.user_first_name');
	   $this->db->select('pt.payment_term_name');	   
	    $this->db->select('r.route_name');
       $this->db->from('loan_payment b');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	   $this->db->join('loan l', 'l.loan_id = b.loan_id', 'left');
	   $this->db->join('routes r', 'r.route_id = b.route_id', 'left');
	   $this->db->join('user u', 'u.user_id = b.user_id', 'left');
	   $this->db->join('mstr_payment_terms pt', 'pt.id = b.payment_term', 'left');
	   
	   
	   //$this->db->where("b.pymnt_paying_by","Cash");
	  $this->db->where("b.pymnt_collected",1);
	  // $this->db->where("b.pymnt_returned",0);	   
	   $this->db->where("b.loan_id",$loan_id);
	   
	   if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	   }   
	   
	    if($srh_from_date){	   
	    $this->db->where("b.pymnt_date_time >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.pymnt_date_time <=",$srh_to_date);
	   }
	   $query = $this->db->get();	  
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }
   
   //--------------------------------------------------------------
   //REF : Not Close Report   
    function get_not_close_loan_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select_sum('b.total_interest');
	   $this->db->select_sum('b.loan_tot_amount');
	   $this->db->select_sum('b.loan_payable_total_amount');
       $this->db->from('loan b');
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);
	   if($srh_from_date){	   
	    $this->db->where("b.loan_close_date >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.loan_close_date <=",$srh_to_date);
	   }
	   else
		{
		$this->db->where("b.loan_close_date <=","0000-00-00");
		}
	   if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	   }	   
	    if($route_id){	   
	   $this->db->where("b.route_id",$route_id);
	   }	   
	     if($loan_payment_term){	   
	   $this->db->where("b.loan_payment_term",$loan_payment_term);
	   }  	   
	   $query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       return $query->row_array();
	   }
    	else
		{
       return false;
     	}	   
   }
   
   
   
   function get_not_close_loan_summary_panalty($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select_sum('lp.panalty_amount');
       $this->db->from('loan_panalty lp');
	   $this->db->join('loan b', 'lp.loan_id = b.loan_id', 'inner');
	   $this->db->where("lp.is_removed",0);
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);	   
	    if($srh_from_date){	   
	    $this->db->where("b.loan_close_date >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.loan_close_date <=",$srh_to_date);
	   }
	   else
		{
		$this->db->where("b.loan_close_date <=","0000-00-00");
		}
	   if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	   }	   
	    if($route_id){	   
	   $this->db->where("b.route_id",$route_id);
	   }	   
	     if($loan_payment_term){	   
	   $this->db->where("b.loan_payment_term",$loan_payment_term);
	   }  
	     
	   $query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       return $query->row_array();
	   }
    	else
		{
       return false;
     	}	   
   }
   
    function get_not_close_loan_summary_due($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select_sum('lp.due_amount');
       $this->db->from('loan_due_amount lp');
	   $this->db->join('loan b', 'lp.loan_id = b.loan_id', 'left');
	   $this->db->where("lp.is_removed",0);
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);	   
	    if($srh_from_date){	   
	    $this->db->where("b.loan_close_date >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.loan_close_date <=",$srh_to_date);
	   }
	   else
		{
		$this->db->where("b.loan_close_date <=","0000-00-00");
		}
	   if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	   }	   
	    if($route_id){	   
	   $this->db->where("b.route_id",$route_id);
	   }	   
	     if($loan_payment_term){	   
	   $this->db->where("b.loan_payment_term",$loan_payment_term);
	   }  	     
	   $query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       return $query->row_array();
	   }
    	else
		{
       return false;
     	}	   
   }  
   
    function get_not_close_loan_paid_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	$this->db->select_sum('lp.loan_received');
	$this->db->select_sum('lp.capital_received');
	$this->db->select_sum('lp.loan_interest_recived');
	$this->db->select_sum('lp.panalty_received');
	$this->db->select_sum('lp.due_received');
	$this->db->select_sum('lp.excess_received');
	$this->db->select_sum('lp.pymnt_amount');
    $this->db->from('loan_payment lp');
	$this->db->join('loan b', 'lp.loan_id = b.loan_id', 'inner');
	$this->db->where("lp.pymnt_collected",1);
	$this->db->where("lp.pymnt_returned",0);
	$this->db->where("b.approval_status",1); 
	$this->db->where("b.is_closed",0); 
	if($srh_from_date){	   
	    $this->db->where("b.loan_close_date >=",$srh_from_date);
	}
	if($srh_to_date){	   
	    $this->db->where("b.loan_close_date <=",$srh_to_date);
	}else
	{
		$this->db->where("b.loan_close_date <=","0000-00-00");
	}
	if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	}	   
	if($route_id){	   
	 $this->db->where("b.route_id",$route_id);
	 }	   
	 if($loan_payment_term){	   
	 $this->db->where("b.loan_payment_term",$loan_payment_term);
	 } 	   
	   $query = $this->db->get();	  
     if($query->num_rows() >0)
     {
       return $query->row_array();
     }
     else
     {
       return false;
     }
   }
   
   function get_not_close_loan_list($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select('b.*,c.cus_name');
	   $this->db->select('mpt.payment_term_name');
	   $this->db->select('r.route_name');
       $this->db->from('loan b');
	  // $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	   $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
	   $this->db->join('routes r', 'r.route_id = b.route_id', 'left');
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);	    
		if($srh_from_date){	   
	    $this->db->where("b.loan_close_date >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.loan_close_date <=",$srh_to_date);
	   }
	   if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	   }	   
	    if($route_id){	   
	   $this->db->where("b.route_id",$route_id);
	   }	   
	     if($loan_payment_term){	   
	   $this->db->where("b.loan_payment_term",$loan_payment_term);
	   }  
	   
	   $this->db->order_by("b.loan_close_date", "desc");	   
	   $query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       return $query->result();
	   }
    	else
		{
       return false;
     	}	   
   }
   
   //---------------------------------------------------------
   
   
   function get_not_close_loan_list_2($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select('b.*,c.cus_name');
	   $this->db->select('mpt.payment_term_name');
	   $this->db->select('r.route_name');
       $this->db->from('loan b');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	   $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
	   $this->db->join('routes r', 'r.route_id = b.route_id', 'left');
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);	    
		if($srh_from_date){	   
	    $this->db->where("b.loan_date >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.loan_date <=",$srh_to_date);
	   }
	   if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	   }	   
	    if($route_id){	   
	   $this->db->where("b.route_id",$route_id);
	   }	   
	     if($loan_payment_term){	   
	   $this->db->where("b.loan_payment_term",$loan_payment_term);
	   }  
	   
	   $this->db->order_by("b.loan_id", "desc");	   
	   $query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       return $query->result();
	   }
    	else
		{
       return false;
     	}	   
   }
   
   //---------------------------------------------------------
   
   
   
   
   
   //----------------------------------------------------------
   //REF : Loan report
   function get_loan_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select_sum('b.total_interest');
	   $this->db->select_sum('b.loan_tot_amount');
	   $this->db->select_sum('b.loan_payable_total_amount');
       $this->db->from('loan b');
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);
	   if($srh_from_date){	   
	    $this->db->where("b.loan_date >=",$srh_from_date);
		}
		if($srh_to_date){	   
	    $this->db->where("b.loan_date <=",$srh_to_date);
		}	
		if($wareh_id){	   
	  	 $this->db->where("b.warehouse_id",$wareh_id);//
		}
		if($route_id){	   
		 $this->db->where("b.route_id",$route_id);//
		 }	   
		 if($loan_payment_term){	   
		 $this->db->where("b.loan_payment_term",$loan_payment_term);//
		 }   	
	   $query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       return $query->row_array();
	   }
    	else
		{
       return false;
     	}	   
   }
   
   function get_loan_summary_panalty($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select_sum('lp.panalty_amount');
       $this->db->from('loan_panalty lp');
	   $this->db->join('loan b', 'lp.loan_id = b.loan_id', 'inner');
	   $this->db->where("lp.is_removed",0);
	    $this->db->where("b.approval_status",1);	
		$this->db->where("b.is_closed",0);   
	     if($srh_from_date){	   
	    $this->db->where("b.loan_date >=",$srh_from_date);
		}
		if($srh_to_date){	   
	    $this->db->where("b.loan_date <=",$srh_to_date);
		}	
		if($wareh_id){	   
	  	 $this->db->where("b.warehouse_id",$wareh_id);//
		}
		if($route_id){	   
		 $this->db->where("b.route_id",$route_id);//
		 }	   
		 if($loan_payment_term){	   
		 $this->db->where("b.loan_payment_term",$loan_payment_term);//
		 }   	
	   	$query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       	return $query->row_array();
	  	 }
    	else{
       	return false;
     	}	   
   }
   
    function get_loan_summary_due($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
    {
	   $this->db->select_sum('lp.due_amount');
       $this->db->from('loan_due_amount lp');
	   $this->db->join('loan b', 'lp.loan_id = b.loan_id', 'left');
	   $this->db->where("lp.is_removed",0);	
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);  
	   if($srh_from_date){	   
	    $this->db->where("b.loan_date >=",$srh_from_date);
		}
		if($srh_to_date){	   
	    $this->db->where("b.loan_date <=",$srh_to_date);
		}	
		if($wareh_id){	   
	  	 $this->db->where("b.warehouse_id",$wareh_id);//
		}
		if($route_id){	   
		 $this->db->where("b.route_id",$route_id);//
		 }	   
		 if($loan_payment_term){	   
		 $this->db->where("b.loan_payment_term",$loan_payment_term);//
		 }   	
	   	$query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
      	 return $query->row_array();
	  	 }
    	else
		{
      	 return false;
     	}	   
   }
   
   function get_loan_paid_summary($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	$this->db->select_sum('lp.loan_received');
	$this->db->select_sum('lp.capital_received');
	$this->db->select_sum('lp.loan_interest_recived');
	$this->db->select_sum('lp.panalty_received');
	$this->db->select_sum('lp.due_received');
	$this->db->select_sum('lp.excess_received');
	$this->db->select_sum('lp.pymnt_amount');
    $this->db->from('loan_payment lp');
	$this->db->join('loan b', 'lp.loan_id = b.loan_id', 'inner');
	$this->db->where("lp.pymnt_collected",1);
	$this->db->where("lp.pymnt_returned",0); 
	$this->db->where("b.approval_status",1);
	$this->db->where("b.is_closed",0);
	if($srh_from_date){	   
	    $this->db->where("b.loan_date >=",$srh_from_date);
	}
	if($srh_to_date){	   
	    $this->db->where("b.loan_date <=",$srh_to_date);
	}	
	if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);//
	}
	if($route_id){	   
	 $this->db->where("b.route_id",$route_id);//
	 }	   
	 if($loan_payment_term){	   
	 $this->db->where("b.loan_payment_term",$loan_payment_term);//
	 }   	   
	 $query = $this->db->get();	  
     if($query->num_rows() >0)
     {
       return $query->row_array();
     }
     else
     {
       return false;
     }
   }
   
   //----------------------------------------------------------
   
   
   //----------------------------------------------------------
   public function get_user_summary($user_id,$date,$route)
   {
	   $this->db->select('lp.paymnt_id,lp.pymnt_ref_no,lp.pymnt_amount,lp.pymnt_added_date_time,b.loan_ref');
	   $this->db->from('loan_payment lp');
	    $this->db->join('loan b', 'lp.loan_id = b.loan_id', 'left');
	   $this->db->where("lp.pymnt_collected",1); 
	   $this->db->where("lp.pymnt_deposited",1);  
	   $this->db->where("lp.user_id",$user_id);
	  $this->db->where("lp.pymnt_date_time",$date); 
	  $this->db->where("lp.route_id",$route);
	   $query = $this->db->get();	  
    	 if($query->num_rows() >0)
    	 {
     	  return $query->result_array();
    	 }
    	 else
    	 {
      	 return false;
		 }	      
   }
   
   //----------------------------------------------------------
      function getLoan_approved_issued($warehouse_id,$route,$payment_t)
   {
	   $this->db->select('b.*,c.cus_name,c.cus_phone');
	    $this->db->select('mpt.payment_term_name');
       $this->db->from('loan b');
	   $this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	    $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');		
		$approval_status_con="b.approval_status =1";
		$is_closed_con=" AND b.is_closed =0";
		$loan_issue_status_con=" AND b.loan_issue_status =1";		
		$loan_payment_term_con="";	
		$route_id_con="";
		$warehouse_id_con="";	 	
		if($warehouse_id){
		$warehouse_id_con=" AND b.warehouse_id =".$warehouse_id." ";			
		}		
		if($route){
		$route_id_con=" AND b.route_id =".$route." ";	
		}		
		if($payment_t){
		$loan_payment_term_con=" AND b.loan_payment_term =".$payment_t." ";	
		}		
		$where_condition=$approval_status_con.$is_closed_con.$warehouse_id_con.$route_id_con.$loan_payment_term_con.$loan_issue_status_con;		
		$this->db->where($where_condition);		
		$this->db->order_by("c.cus_name", "desc");
       	$query = $this->db->get(); 
      	return $query->result(); 	  
   }
   
   
   
    //---------------------------------------------------------
   
   
   function get_expire_closing_date_loans($wareh_id,$route_id,$loan_payment_term,$srh_from_date,$srh_to_date)
   {
	   $this->db->select('b.*,c.cus_name');
	   $this->db->select('mpt.payment_term_name');
	   $this->db->select('r.route_name');
       $this->db->from('loan b');
	   //$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	   $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');
	   $this->db->join('routes r', 'r.route_id = b.route_id', 'left');
	   $this->db->where("b.approval_status",1);
	   $this->db->where("b.is_closed",0);	    
		if($srh_from_date){	   
	    $this->db->where("b.loan_close_date >=",$srh_from_date);
	   }
	   if($srh_to_date){	   
	    $this->db->where("b.loan_close_date <=",$srh_to_date);
	   }
	   if($wareh_id){	   
	   $this->db->where("b.warehouse_id",$wareh_id);
	   }	   
	    if($route_id){	   
	   $this->db->where("b.route_id",$route_id);
	   }	   
	     if($loan_payment_term){	   
	   $this->db->where("b.loan_payment_term",$loan_payment_term);
	   }  
	   
	   $this->db->order_by("b.loan_id", "desc");	   
	   $query = $this->db->get();
     	if($query->num_rows() >0)
    	 {
       return $query->result();
	   }
    	else
		{
       return false;
     	}	   
   }
   
   //---------------------------------------------------------
    //---------------------------------------------------------
   
   
   
   function currant_operation_loan_list($warehouse_id,$route,$payment_t,$srh_from_date,$srh_to_date,$start,$length,$search_key_val)
   {
	   $this->db->select('b.*,c.cus_name,c.cus_address,c.cus_mobile');
	   $this->db->select('mpt.payment_term_name');
	   $this->db->select('r.route_name');
       $this->db->from('loan b');
	   //$this->db->join('warehouses w', 'w.id = b.warehouse_id', 'left');
	   $this->db->join('customer c', 'c.cus_id = b.cus_id', 'left');
	   $this->db->join('mstr_payment_terms mpt', 'mpt.id = b.loan_payment_term', 'left');	   
	   $this->db->join('routes r', 'r.route_id = b.route_id', 'left');
	 	$approval_status_con="b.approval_status =1";
		$is_closed_con=" AND b.is_closed =0";
		
		$loan_payment_term_con="";	
		$route_id_con="";
		$warehouse_id_con="";
		$srh_from_date_con="";	
		$srh_to_date_con="";
	 	
		if($warehouse_id){
		$warehouse_id_con=" AND b.warehouse_id =".$warehouse_id." ";			
		}		
		if($route){
		$route_id_con=" AND b.route_id =".$route." ";	
		}		
		if($payment_t){
		$loan_payment_term_con=" AND b.loan_payment_term =".$payment_t." ";	
		}
		if($srh_from_date){
		$srh_from_date=date('Y-m-d', strtotime($srh_from_date));
		$srh_from_date_con=" AND b.loan_date >= '".$srh_from_date."' ";	
		}
		if($srh_to_date){
		$srh_to_date=date('Y-m-d', strtotime($srh_to_date));
		$srh_to_date_con=" AND b.loan_date <= '".$srh_to_date."' ";	
		}
			
		$where_condition=$approval_status_con.$is_closed_con.$warehouse_id_con.$route_id_con.$loan_payment_term_con.$srh_from_date_con.	
		$srh_to_date_con;
		
		if($search_key_val)
		{
			$this->db->where($where_condition.' AND c.cus_code LIKE \'%'.$search_key_val.'%\'');
            $this->db->or_where($where_condition.' AND c.cus_name LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where($where_condition.' AND c.cus_nic LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where($where_condition.' AND c.cus_mobile LIKE \'%'.$search_key_val.'%\'');
			$this->db->or_where($where_condition.' AND b.loan_ref LIKE \'%'.$search_key_val.'%\'');				
		}
		else
		{
			$this->db->where($where_condition);
		}
		$this->db->order_by("b.loan_id", "desc");
       if($start!='' && $length!='')
	   {
        $this->db->limit($length,$start);
       	$query = $this->db->get();
		//print_r($this->db->last_query()); 
      	return $query->result();
		     		
	   }
		else
		{
			$query = $this->db->get(); 
			return  $query->num_rows();			
		}
		
    
   }
   
    public function get_not_paid_loans_by_date($date)
    {
        $this->db->select("
            l.loan_id,
            l.loan_ref,
            c.cus_name,
            l.loan_tot_amount,
            l.loan_term_amount,
            l.loan_date,
            l.loan_payment_term,
            mpt.payment_term_name,
            mpt.days
        ");
        $this->db->from('loan l');
        // Join payment terms
        $this->db->join('mstr_payment_terms mpt','mpt.id = l.loan_payment_term','left');
        // Join loan_payment ONLY for the given date
        $this->db->join('loan_payment lp','lp.loan_id = l.loan_id AND lp.pymnt_date_time = "'.$date.'"','left');
        $this->db->join('customer c','c.cus_id = l.cus_id','left');
        // Only ongoing loans
        $this->db->where('l.is_closed', 0);
        $this->db->where('l.loan_payment_term', 1);
        // Not paid on given date
        $this->db->where('lp.paymnt_id IS NULL', null, false);
        $this->db->order_by('l.loan_date', 'ASC');
        return $this->db->get()->result_array();
    }


   
   //---------------------------------------------------------
   
}