<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends CI_Controller {

    var $main_menu_name = "reports";
	var $sub_menu_name = "suppliers";

	public function __construct()
	{
		parent::__construct();

		
		$this->load->model('Common_Model');
		$this->load->model('Warehouse_Model');
		
		$this->load->model('Sequerty_Model');
		$this->load->model('Loan_Model');
	}
	
	public function index()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['main_menu_name'] = $this->main_menu_name;
		
		$this->load->view('rep_reports',$data);
	}
	
	public function payments(){
		$this->load->model('User_Model');
		$this->load->model('Route_Model');
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'reports/payments';
		$service_type=$this->uri->segment('3');
		$data['service_type']=$service_type;
		$pageName='';
		$data['user_list'] = $this->User_Model->getUsers();
		$data['pageName'] =$pageName;
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		//$data['vehicle_list'] = $this->Vehicle_Model->get_all_vehicle();
		$data['routes_list']=$this->Route_Model->get_all_active_routes();
		$this->load->view('rep_payments',$data);
	}
	
	public function get_list_payments_for_report()	
{       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$route_id=$this->input->post('route_id');
		$user_id=$this->input->post('user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		 $values = $this->Loan_Model->getPaymentsForPrint($srh_warehouse_id,$srh_to_date,$srh_from_date,$user_id,$route_id);
		
			$columns = array( 
		0 =>'paymnt_id', 
		1 => 'paymnt_id',
		2=> 'loan_id',
		3 =>'loan_id', 
		4 => 'loan_id',
		5=> 'loan_id',
		6=> 'loan_id',
		7=> 'loan_id',
		8=> 'loan_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					
	            $row = array();
					$loan_id=$users->loan_id;
					$paymnt_id=$users->paymnt_id;
					$row[] = $users->paymnt_id;
					$row[] =  $users->user_first_name;	
					  //$row[] = $users->pymnt_ref_no." / ".$users->tracking_number;
					  $row[] = $users->pymnt_date_time;
					   $row[] = '<a target="_blank" href="'.base_url().'loan/details/'.$users->loan_id.'">'.$users->loan_ref.'</a>';
					   $row[] = $users->cus_name;
					    $row[] = number_format($users->due_received, 2, '.', ',');
					   $row[] = number_format($users->panalty_received, 2, '.', ',');
					   $row[] = number_format($users->loan_interest_recived, 2, '.', ',');					   
					   $row[] = number_format($users->capital_received, 2, '.', ',');
					   //$row[] = number_format($users->loan_received, 2, '.', ',');			   
					   $row[] = number_format($users->pymnt_amount, 2, '.', ',');
					  
					if($users->pymnt_paying_by=='Cheque'){  
					
					
					
					/* deposited Status */    
					$pymnt_deposited=$users->pymnt_deposited;
					$checked_status='';
					if($pymnt_deposited==1) {
						$checked_status='checked=\"checked\"';
					}else {
						$checked_status='';
					}
					 /* $row[] = "<label class=\"checkbox-inline\">
										<input id=\"collected_$paymnt_id\" type=\"checkbox\" class=\"flat-red\" value=\"$paymnt_id\" onchange=\"changeColectedStatus($paymnt_id,this.checked,'deposited')\" $checked_status>
										Deposited
									</label>";	*/
					/* End deposited Status */ 
					
					/* Returned Status */    
					$pymnt_returned=$users->pymnt_returned;
					$checked_status='';
					if($pymnt_returned==1) {
						$checked_status='checked=\"checked\"';
					}else {
						$checked_status='';
					}
					
					 /* $row[] = "<label class=\"checkbox-inline\">
										<input id=\"collected_$paymnt_id\" type=\"checkbox\" class=\"flat-red\" value=\"$paymnt_id\" onchange=\"changeColectedStatus($paymnt_id,this.checked,'returned')\" $checked_status>
										Returned
									</label>";	*/
					/* End deposited Status */ 
					}
					else {
						/*$row[] ='';
						$row[] ='';*/
					}
					
					if($users->pymnt_paying_by=='Cash'){
					/* Cash Collected Status */    
					// checked="checked"
					$pymnt_collected=$users->pymnt_collected;
					$checked_status='';
					if($pymnt_collected==1) {
						$checked_status='checked=\"checked\"';
					}else {
						$checked_status='';
					}
					
					/*  $row[] = "<label class=\"checkbox-inline\">
										<input id=\"collected_$paymnt_id\" type=\"checkbox\" class=\"flat-red\" value=\"$paymnt_id\" onchange=\"changeColectedStatus_this_page($paymnt_id,this.checked,'collected')\" $checked_status>
										Collected
									</label>";*/
					 /*$row[] = "<label class=\"checkbox-inline\">
										
										Collected
									</label>";*/
									
									
					
					}else {
						//$row[] ='';
					}
					/* End Cash Collected Status */ 
					
					
					
					
						 	
                      		$paid=0;
							//$paid=$this->Loan_Model->get_total_paid_by_booking_id($bkng_id);
						//$row[] =number_format($paid, 2, '.', ',');
						
							//$row[] =number_format($users->bkng_tot_amount-$paid, 2, '.', ',');
				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;
	
	                $data[] = $row;
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}
//----------------------------------------------------------

public function get_list_payments_for_report_summary()	
{       
	     $data = array();
		//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		$route_id=$this->input->post('route_id');
		$user_id=$this->input->post('user_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		 $values = $this->Loan_Model->getPaymentsForPrint_summary($srh_warehouse_id,$srh_to_date,$srh_from_date,$user_id,$route_id);
		
		$total_paid=0;
		$loan_received=0;
		$capital_received=0;
		$loan_interest_recived=0;
		$panalty_received=0;
		$due_received=0;
			if($values ['pymnt_amount'])
			{
				$total_paid=$values ['pymnt_amount'];
				$loan_received=$values ['loan_received'];
				$capital_received=$values ['capital_received'];
				$loan_interest_recived=$values ['loan_interest_recived'];
				$panalty_received=$values ['panalty_received'];
				$due_received=$values ['due_received'];				
			}
	          $total_income=$loan_interest_recived+$panalty_received+$due_received;

	            $output = array('total_paid' =>$total_paid,'loan_received' =>$loan_received,'capital_received' =>$capital_received,'loan_interest_recived' =>$loan_interest_recived,'panalty_received' =>$panalty_received,'due_received' =>$due_received,'total_income'=>$total_income
				
				
				
				
				);
	            echo json_encode($output);

}








//---------------------------------------------
public function print_booking_report()	
{
	       
	    $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->get('srh_warehouse_id');
		
		if($this->input->get('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->get('srh_to_date')));
		}
		if($this->input->get('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->get('srh_from_date')));
		}
		
		 $data['booking_data']= $this->Loan_Model->getLoansForPrint($srh_warehouse_id,$srh_to_date,$srh_from_date);
		//print_r( $data['booking_data']);
		$this->load->view('models/print_booking_report',$data);

}




public function get_list_bookings_for_report()	
{
	       
	        $data = array();
			//print_r($values);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		
		 $values = $this->Loan_Model->getLoansForPrint($srh_warehouse_id,$srh_to_date,$srh_from_date);
		
			$columns = array( 
		0 =>'bkng_id', 
		1 => 'bkng_id',
		2=> 'bkng_id',
		3 =>'bkng_id', 
		4 => 'bkng_id',
		5=> 'bkng_id',
		6=> 'bkng_id',
		7=> 'bkng_id',
		8=> 'bkng_id'
		);
	        if (!empty($values)) {
	            foreach ($values as $users) {
					
	            $row = array();
					$bkng_id=$users->bkng_id;
					$row[] = $users->bkng_id;
	                $row[] = $users->bkng_refno;
	                $row[] = $users->cus_name;	
	                $row[] = $users->bkng_date;
					$time_cls='';
					if($users->bkng_time=='Morning'){
							$clas="label-success";
						}if($users->bkng_time=='Evening'){
							$clas="label-purple";
						}
	               $row[] = "<span class='label $clas'>".$users->bkng_time."</span>";
					
					 $row[] = $users->bkng_head_count;	
					 
					  
					   $clas='';
					   	if($users->bkng_status=='Confirmed'){
							$clas="label-success";
						}
						if($users->bkng_status=='Removed'){
							$clas="label-inverse";
						}
						
					     $row[] = "<span class='label $clas'>".$users->bkng_status."</span>";	
						  $row[] = $users->bkng_reg_date;
						 															
				
							
						 $row[] = $users->bkng_tot_amount;		
                      		$paid=0;
							$paid=$this->Loan_Model->get_total_paid_by_booking_id($bkng_id);
						$row[] =number_format($paid, 2, '.', ',');
						
							$row[] =number_format($users->bkng_tot_amount-$paid, 2, '.', ',');
				
				//$row[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtPw.$actionTxtDelete;
	
	                $data[] = $row;
	            }


	            $output = array('data' =>$data);
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }

}

	public function booking(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'trial_balance';
		$service_type=$this->uri->segment('3');
		$data['service_type']=$service_type;
		$pageName='';
		
		$data['pageName'] =$pageName;
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		//$data['vehicle_list'] = $this->Vehicle_Model->get_all_vehicle();
		$this->load->view('rep_booking',$data);
	}
	

	
	public function user_activitie(){
		$data['main_menu_name'] = 'reports';
		$data['sub_menu_name'] = 'user_activitie';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$this->load->view('rep_user_activitie',$data);
	}
	

	
	public function get_list_user_activitie_for_print($value='')
	{
		$this->load->model('User_Model');
		//print_r($_REQUEST);
		$srh_to_date='';
		$srh_from_date='';
		$srh_warehouse_id=$this->input->post('srh_warehouse_id');
		if($this->input->post('srh_to_date')){
			$srh_to_date=date('Y-m-d', strtotime($this->input->post('srh_to_date')));
		}
		if($this->input->post('srh_from_date')){
			$srh_from_date=date('Y-m-d', strtotime($this->input->post('srh_from_date')));
		}
		
		$columns = array( 
		0 =>'id', 
		1 => 'id',
		2=> 'id',
		3 =>'id', 
		4 => 'id',
	
	);
	$data = array();
	$grn_data = $this->User_Model->get_all_user_activitie_for_report($srh_warehouse_id,$srh_to_date,$srh_from_date);
	$totalData = count($grn_data);
	$totalFiltered = $totalData;  
	
	foreach ($grn_data as $row){
		$nestedData=array(); 
		$id=$row['id'];
		$nestedData[] =$row['details'];
		/*$nestedData[]=$row['page'];*/ 
		$nestedData[] = $row['user_first_name'];
		$nestedData[] =display_date_time_format($row['datetime']);

	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data);
	}
	
	public function grn()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'grn';
		$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		$this->load->view('rep_grn',$data);
	}
	
	
	
	public function suppliers()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers'] = $this->Supplier_Model->get_all_supplier();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('rep_suppliers',$data);
	}
	
	public function print_supplier()
	{
		$this->load->model('Supplier_Model');
		$data['suppliers_list'] = $this->Supplier_Model->get_all_supplier();

		$this->load->view('models/print_supplier',$data);
	}
	

	
}