<?php $this->load->view("common/header"); ?>

<body>
  <div class="navbar navbar-inverse navbar-fixed-top">
    <div class="container">
      <div class="navbar-header">
        <button data-target=".navbar-collapse" data-toggle="collapse" class="navbar-toggle" type="button"> <span class="clip-list-2"></span> </button>
        <?php $this->load->view("common/logo"); ?>
      </div>
      <div class="navbar-tools">
        <?php $this->load->view("common/notifications.php"); ?>
      </div>
    </div>
  </div>
  <div class="main-container">
    <div class="navbar-content">
      <?php $this->load->view("common/navigation"); ?>
    </div>
    <div class="main-content">
      <div class="container">
        <div class="row">
          <div class="col-sm-12">
            <ol class="breadcrumb">
              <li> <a href="<?php echo base_url('dashboard'); ?>"> Dashboard </a> </li>
              <li> <a href="#"> Reports </a> </li>
              <li class="active"> Day wise Arrears Report </li>
              <li class="search-box">
                <form class="sidebar-search">
                  <div class="form-group">
                    <input type="text" placeholder="Start Searching...">
                    <button class="submit"> <i class="clip-search-3"></i> </button>
                  </div>
                </form>
              </li>
            </ol>
            <div class="page-header">
              <h1>Day wise Arrears Report</h1>
            </div>
            <p>Please use the table below to navigate or filter the results.</p>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <div class="panel panel-default">
              <div class="panel-heading"> <i class="fa fa-external-link-square"></i> Day wise Arrears Report
                <div class="panel-tools" style="top:2px;"></div>
              </div>
              <div class="panel-body">
                <div id="error"></div>
                <div class="col-md-12">
                  <div class="panel panel-default">
                    <div style="font-weight: 700;" class="panel-heading"></div>
                    <div class="panel-body">
                      <form method="post" action="<?php echo base_url('reports_loan/day_arrears_report'); ?>">
                        
                        <div class="col-sm-3">
                          <div class="form-group">
                            <label>Date </label>
                            <input id="srh_from_date" name="srh_from_date" type='text' class="form-control date" value="<?php echo $selected_date; ?>" data-bv-field="date" />
                          </div>
                        </div>
                        <div class="col-sm-4 pull-right">
                          <div class="form-group">
                            <label for="s2id_autogen1">&nbsp;<br><br></label>
                            <input type="submit" name="add_category" value="Search" class="btn btn-primary">
                            <input type="submit" name="add_category" value="Reset" class="btn btn-danger" onclick="searchDetailsReset()">
                          </div>
                        </div>
                      </form>
                    </div>
                  </div>
                 
                  <table class="table table-bordered table-condensed table-hover dataTable" id="loan_table">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Loan Number</th>
                      <th>Customer Name</th>
                      <th class="text-right">Term Amount</th>
                    </tr>
                  </thead>
                
                  <tbody>
                    <?php if (!empty($loans)): ?>
                      <?php $i = 1; foreach ($loans as $row): ?>
                        <tr>
                          <td><?php echo $i++; ?></td>
                          <td><?php echo $row['loan_ref']; ?></td>
                          <td><?php echo $row['cus_name'] ?: 'N/A'; ?></td>
                          <td class="text-right">
                            <?php echo number_format($row['loan_term_amount'], 2); ?>
                          </td>
                        </tr>
                      <?php endforeach; ?>
                    <?php else: ?>
                      <tr>
                        <td colspan="4" class="text-center">
                          No unpaid loans found for selected date.
                        </td>
                      </tr>
                    <?php endif; ?>
                  </tbody>
                
                  <tfoot>
                    <tr>
                      <th colspan="3" class="text-right">Total</th>
                      <th class="text-right">
                        Rs. <?php echo number_format(array_sum(array_column($loans, 'loan_term_amount')), 2); ?>
                      </th>
                    </tr>
                  </tfoot>
                </table>



                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="footer clearfix">
      <div class="footer-inner"> <?php echo date("Y"); ?> &copy; A.S.S.K Loan Management System </div>
      <div class="footer-items"> <span class="go-top"><i class="clip-chevron-up"></i></span> </div>
    </div>
    <?php $this->load->view("common/footer"); ?>
    <script src="<?php echo asset_url(); ?>js/jquery-ui.js"></script>
    <script src="<?php echo asset_url(); ?>js/moment-with-locales.js"></script>
    <script type="text/javascript" src="<?php echo asset_url(); ?>js/bootstrap-datetimepicker.js"></script>
    <script type="text/javascript" src="<?php echo asset_url(); ?>js/bootbox.min.js"></script>
    <script type="text/javascript" src="<?php echo asset_url(); ?>js/accounting.js"></script>
    <script type="text/javascript" src="<?php echo asset_url(); ?>js/accounting.min.js"></script>
    <script type="text/javascript" src="<?php echo asset_url(); ?>js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo asset_url(); ?>js/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.6/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.print.min.js"></script>
    <script>
      function searchDetailsReset() {
        $('#srh_from_date').val('');
        $('#user_id').val('');
        window.location.reload();
      }

      function searchDetails() {
          $('#loan_table').DataTable({
            dom: 'Blfrtip',
            buttons: [{
              extend: 'print',
              text: 'Print',
              title: 'Day Wise Arrears Report',
              footer: true
            }],
            bDestroy: true,
            iDisplayLength: 20,
            order: [[0, "asc"]]
          });
        }


      jQuery(document).ready(function() {
        $('#srh_from_date').datetimepicker({
          defaultDate: new Date(),
          format: "YYYY-MM-DD"
        });
        <?php if ($loans): ?>
          searchDetails();
        <?php endif; ?>
      });

      $(document).on('click', 'tr', function(event) {
        $('tr').css('background-color', 'inherit');
        $(this).css('background-color', '#0F6');
      });
    </script>
</body>

</html>